/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.sequence;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;

public final class TokenListSlicer {
    final List<? extends XMLToken> sequence1;
    final List<? extends XMLToken> sequence2;
    int startCount = -1;
    int endCount = -1;

    public TokenListSlicer(List<? extends XMLToken> seq0, List<? extends XMLToken> seq1) {
        this.sequence1 = seq0;
        this.sequence2 = seq1;
    }

    public int analyze() throws IllegalStateException {
        this.startCount = this.computeStart();
        this.endCount = this.sliceEnd(this.startCount);
        return this.startCount + this.endCount;
    }

    public int computeStart() throws IllegalStateException {
        int toBeRemoved = 0;
        int depth = 0;
        Iterator<? extends XMLToken> i = this.sequence1.iterator();
        Iterator<? extends XMLToken> j = this.sequence2.iterator();
        int counter = 0;
        while (i.hasNext() && j.hasNext()) {
            XMLToken token = i.next();
            if (!j.next().equals(token)) break;
            ++counter;
            if (token instanceof StartElementToken) {
                ++depth;
            } else if (token instanceof EndElementToken) {
                --depth;
            }
            if (depth != 1 && depth != 0) continue;
            toBeRemoved = counter;
        }
        return toBeRemoved;
    }

    public int sliceEnd(int start) throws IllegalStateException {
        XMLToken token;
        int depth = 0;
        int toBeRemoved = 0;
        int counter = 0;
        int pos1 = this.sequence1.size() - 1;
        for (int pos2 = this.sequence2.size() - 1; pos1 >= start && pos2 >= start && (token = this.sequence1.get(pos1)).equals(this.sequence2.get(pos2)); --pos1, --pos2) {
            ++counter;
            if (token instanceof EndElementToken) {
                ++depth;
            } else if (token instanceof StartElementToken) {
                --depth;
            }
            if (depth != 1 && depth != 0) continue;
            toBeRemoved = counter;
        }
        return toBeRemoved;
    }

    public void handleStart(DiffHandler<XMLToken> handler) {
        for (int i = 0; i < this.startCount; ++i) {
            handler.handle(Operator.MATCH, this.sequence1.get(i));
        }
    }

    public void handleEnd(DiffHandler<XMLToken> handler) {
        int from = this.sequence1.size() - this.endCount;
        int to = this.sequence1.size();
        for (int i = from; i < to; ++i) {
            handler.handle(Operator.MATCH, this.sequence1.get(i));
        }
    }

    public int getStartCount() {
        return this.startCount;
    }

    public int getEndCount() {
        return this.endCount;
    }

    public List<? extends XMLToken> getStart() {
        if (this.startCount <= 0) {
            return Collections.emptyList();
        }
        return this.sequence1.subList(0, this.startCount);
    }

    public List<? extends XMLToken> getEnd() {
        if (this.endCount <= 0) {
            return Collections.emptyList();
        }
        int size = this.sequence1.size();
        return this.sequence1.subList(size - this.endCount, size);
    }

    public List<? extends XMLToken> getSubSequence1() {
        if (this.startCount <= 0 && this.endCount <= 0) {
            return this.sequence1;
        }
        return this.sequence1.subList(this.startCount, this.sequence1.size() - this.endCount);
    }

    public List<? extends XMLToken> getSubSequence2() {
        if (this.startCount <= 0 && this.endCount <= 0) {
            return this.sequence2;
        }
        return this.sequence2.subList(this.startCount, this.sequence2.size() - this.endCount);
    }
}

