/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.load;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.pageseeder.diffx.api.Loader;
import org.pageseeder.diffx.api.LoadingException;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.xml.Sequence;
import org.xml.sax.InputSource;

public interface XMLLoader
extends Loader<XMLToken> {
    public Sequence load(InputSource var1) throws LoadingException, IOException;

    default public Sequence load(File file) throws LoadingException, IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            Sequence sequence = this.load(new InputSource(in));
            return sequence;
        }
    }

    default public Sequence load(File file, Charset charset) throws LoadingException, IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset));){
            Sequence sequence = this.load(new InputSource(reader));
            return sequence;
        }
    }

    default public Sequence load(Reader reader) throws LoadingException, IOException {
        return this.load(new InputSource(reader));
    }

    default public Sequence load(String source) throws LoadingException {
        try {
            return this.load(new InputSource(new StringReader(source)));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

