/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.diffx.action;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.xml.Sequence;

public final class Operations {
    private Operations() {
    }

    public static <T> List<T> generate(List<Operation<T>> operations, boolean forward) {
        LinkedList<T> generated = new LinkedList<T>();
        for (Operation<T> operation : operations) {
            if (forward ? operation.operator() == Operator.INS : operation.operator() == Operator.DEL) {
                generated.add(operation.token());
                continue;
            }
            if (operation.operator() != Operator.MATCH) continue;
            generated.add(operation.token());
        }
        return generated;
    }

    public static <T> List<Operation<T>> flip(List<Operation<T>> operations) {
        ArrayList<Operation<T>> reverse = new ArrayList<Operation<T>>(operations.size());
        for (Operation<T> operation : operations) {
            reverse.add(operation.flip());
        }
        return reverse;
    }

    public static Sequence apply(Sequence input, List<Operation<XMLToken>> operations) {
        List<XMLToken> tokens = Operations.apply(input.tokens(), operations);
        Sequence out = new Sequence(tokens.size());
        out.addTokens(tokens);
        return out;
    }

    public static <T> List<T> apply(List<T> input, List<Operation<T>> operations) {
        ArrayList<T> out = new ArrayList<T>(input.size());
        int i = 0;
        try {
            for (Operation<T> operation : operations) {
                switch (operation.operator()) {
                    case MATCH: {
                        out.add(input.get(i));
                        ++i;
                        break;
                    }
                    case INS: {
                        out.add(operation.token());
                        break;
                    }
                    case DEL: {
                        ++i;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("Actions cannot be applied to specified input", ex);
        }
        if (i != input.size()) {
            throw new IllegalArgumentException("Actions do not match specified input");
        }
        return out;
    }

    public static <T> void handle(List<Operation<T>> operations, DiffHandler<T> handler) {
        for (Operation<T> operation : operations) {
            handler.handle(operation.operator(), operation.token());
        }
    }
}

