/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.xmlgraphics;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.jeuclid.context.LayoutContextImpl;
import net.sourceforge.jeuclid.layout.JEuclidView;
import net.sourceforge.jeuclid.parser.Parser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.util.UnclosableInputStream;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PreloaderMathML
extends AbstractImagePreloader {
    public static final float MPT_FACTOR = 1000.0f;
    private static final Log LOGGER = LogFactory.getLog(PreloaderMathML.class);

    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) throws ImageException, IOException {
        Document document = this.parseSource(source);
        if (document != null) {
            return this.createImageInfo(string, imageContext, document);
        }
        return null;
    }

    private ImageInfo createImageInfo(String string, ImageContext imageContext, Document document) {
        ImageInfo imageInfo = new ImageInfo(string, "application/mathml+xml");
        ImageSize imageSize = new ImageSize();
        JEuclidView jEuclidView = new JEuclidView((Node)document, LayoutContextImpl.getDefaultLayoutContext(), null);
        int n = (int)(jEuclidView.getDescentHeight() * 1000.0f);
        int n2 = (int)(jEuclidView.getAscentHeight() * 1000.0f);
        imageSize.setSizeInMillipoints((int)(jEuclidView.getWidth() * 1000.0f), n2 + n);
        imageSize.setBaselinePositionFromBottom(n);
        imageSize.setResolution((double)imageContext.getSourceResolution());
        imageSize.calcPixelsFromSize();
        imageInfo.setSize(imageSize);
        ImageXMLDOM imageXMLDOM = new ImageXMLDOM(imageInfo, document, "http://www.w3.org/1998/Math/MathML");
        imageInfo.getCustomObjects().put(ImageInfo.ORIGINAL_IMAGE, imageXMLDOM);
        return imageInfo;
    }

    private Document parseSource(Source source) {
        Document document = null;
        UnclosableInputStream unclosableInputStream = null;
        try {
            Object object;
            if (source instanceof DOMSource) {
                object = (DOMSource)source;
                document = (Document)((DOMSource)object).getNode();
            } else {
                unclosableInputStream = new UnclosableInputStream(ImageUtil.needInputStream((Source)source));
                int n = unclosableInputStream.available();
                unclosableInputStream.mark(n + 1);
                document = Parser.getInstance().parseStreamSource(new StreamSource((InputStream)unclosableInputStream));
            }
            object = document.getDocumentElement();
            if (!"http://www.w3.org/1998/Math/MathML".equals(object.getNamespaceURI()) && !"math".equals(object.getNodeName())) {
                document = null;
            }
        }
        catch (IOException iOException) {
            document = null;
        }
        catch (SAXException sAXException) {
            document = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            document = null;
        }
        catch (NullPointerException nullPointerException) {
            document = null;
        }
        try {
            if (unclosableInputStream != null) {
                unclosableInputStream.reset();
            }
        }
        catch (IOException iOException) {
            LOGGER.warn((Object)("Should never happen: " + iOException.getMessage()));
        }
        catch (NullPointerException nullPointerException) {
            document = null;
        }
        return document;
    }
}

