/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.expression.AggregateNumericExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.util.Localiser;

public abstract class SimpleNumericAggregateMethod
implements SQLMethod {
    protected abstract String getFunctionName();

    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (expr != null) {
            throw new NucleusException(Localiser.msg((String)"060002", (Object[])new Object[]{this.getFunctionName(), expr}));
        }
        if (args == null || args.size() != 1) {
            throw new NucleusException(this.getFunctionName() + " is only supported with a single argument");
        }
        if (stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.RESULT || stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.HAVING) {
            SQLExpression argExpr = args.get(0);
            JavaTypeMapping m = argExpr.getJavaTypeMapping();
            return new AggregateNumericExpression(stmt, m, this.getFunctionName(), args);
        }
        ClassLoaderResolver clr = stmt.getQueryGenerator().getClassLoaderResolver();
        SQLExpression argExpr = args.get(0);
        SelectStatement subStmt = new SelectStatement(stmt, stmt.getRDBMSManager(), argExpr.getSQLTable().getTable(), argExpr.getSQLTable().getAlias(), null);
        subStmt.setClassLoaderResolver(clr);
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        JavaTypeMapping mapping = stmt.getRDBMSManager().getMappingManager().getMappingWithColumnMapping(String.class, false, false, clr);
        String aggregateString = this.getFunctionName() + "(" + argExpr.toSQLText() + ")";
        SQLExpression aggExpr = exprFactory.newLiteral(subStmt, mapping, aggregateString);
        ((StringLiteral)aggExpr).generateStatementWithoutQuotes();
        subStmt.select(aggExpr, null);
        JavaTypeMapping subqMapping = exprFactory.getMappingForType(Integer.class, false);
        NumericSubqueryExpression subqExpr = new NumericSubqueryExpression(stmt, subStmt);
        subqExpr.setJavaTypeMapping(subqMapping);
        return subqExpr;
    }

    protected abstract Class getClassForMapping();
}

