/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.util.ClassUtils;

public class ReferenceIdMapping
extends ReferenceMapping {
    public ReferenceIdMapping(ReferenceMapping refMapping) {
        this.initialize(refMapping.storeMgr, refMapping.type);
        this.table = refMapping.table;
        this.javaTypeMappings = new JavaTypeMapping[refMapping.javaTypeMappings.length];
        System.arraycopy(refMapping.javaTypeMappings, 0, this.javaTypeMappings, 0, this.javaTypeMappings.length);
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet rs, int[] param) {
        Object value = super.getObject(ec, rs, param);
        if (value != null) {
            ApiAdapter api = ec.getApiAdapter();
            return api.getIdForObject(value);
        }
        return null;
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] param, Object value) {
        if (value == null) {
            super.setObject(ec, ps, param, null);
            return;
        }
        if (this.mappingStrategy == 1 || this.mappingStrategy == 2) {
            String refString = this.getReferenceStringForObject(ec, value);
            this.getJavaTypeMapping()[0].setString(ec, ps, param, refString);
            return;
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        int colPos = 0;
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            int[] cols = new int[this.javaTypeMappings[i].getNumberOfColumnMappings()];
            for (int j = 0; j < cols.length; ++j) {
                cols[j] = param[colPos++];
            }
            Class cls = clr.classForName(this.javaTypeMappings[i].getType());
            AbstractClassMetaData implCmd = ec.getMetaDataManager().getMetaDataForClass(cls, clr);
            if (implCmd.getObjectidClass().equals(value.getClass().getName())) {
                Object key;
                if (IdentityUtils.isDatastoreIdentity((Object)value)) {
                    key = IdentityUtils.getTargetKeyForDatastoreIdentity((Object)value);
                    if (key instanceof String) {
                        this.javaTypeMappings[i].setString(ec, ps, cols, (String)key);
                        continue;
                    }
                    this.javaTypeMappings[i].setObject(ec, ps, cols, key);
                    continue;
                }
                if (IdentityUtils.isSingleFieldIdentity((Object)value)) {
                    key = IdentityUtils.getTargetKeyForSingleFieldIdentity((Object)value);
                    if (key instanceof String) {
                        this.javaTypeMappings[i].setString(ec, ps, cols, (String)key);
                        continue;
                    }
                    this.javaTypeMappings[i].setObject(ec, ps, cols, key);
                    continue;
                }
                String[] pkMemberNames = implCmd.getPrimaryKeyMemberNames();
                for (int j = 0; j < pkMemberNames.length; ++j) {
                    Object pkMemberValue = ClassUtils.getValueForIdentityField((Object)value, (String)pkMemberNames[j]);
                    if (pkMemberValue instanceof Byte) {
                        this.getColumnMapping(j).setByte(ps, param[j], (Byte)pkMemberValue);
                        continue;
                    }
                    if (pkMemberValue instanceof Character) {
                        this.getColumnMapping(j).setChar(ps, param[j], ((Character)pkMemberValue).charValue());
                        continue;
                    }
                    if (pkMemberValue instanceof Integer) {
                        this.getColumnMapping(j).setInt(ps, param[j], (Integer)pkMemberValue);
                        continue;
                    }
                    if (pkMemberValue instanceof Long) {
                        this.getColumnMapping(j).setLong(ps, param[j], (Long)pkMemberValue);
                        continue;
                    }
                    if (pkMemberValue instanceof Short) {
                        this.getColumnMapping(j).setShort(ps, param[j], (Short)pkMemberValue);
                        continue;
                    }
                    if (pkMemberValue instanceof String) {
                        this.getColumnMapping(j).setString(ps, param[j], (String)pkMemberValue);
                        continue;
                    }
                    this.getColumnMapping(j).setObject(ps, param[j], pkMemberValue);
                }
                continue;
            }
            this.javaTypeMappings[i].setObject(ec, ps, cols, null);
        }
    }
}

