/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.connectionpool;

import java.util.Properties;
import javax.sql.DataSource;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.connectionpool.AbstractConnectionPoolFactory;
import org.datanucleus.store.rdbms.connectionpool.ConnectionPool;
import org.datanucleus.store.rdbms.connectionpool.DatastorePoolException;
import org.datanucleus.store.rdbms.datasource.dbcp2.DriverManagerConnectionFactory;
import org.datanucleus.store.rdbms.datasource.dbcp2.PoolableConnection;
import org.datanucleus.store.rdbms.datasource.dbcp2.PoolableConnectionFactory;
import org.datanucleus.store.rdbms.datasource.dbcp2.PoolingDataSource;
import org.datanucleus.store.rdbms.datasource.dbcp2.pool2.impl.GenericObjectPool;
import org.datanucleus.util.StringUtils;

public class DBCP2BuiltinConnectionPoolFactory
extends AbstractConnectionPoolFactory {
    @Override
    public ConnectionPool createConnectionPool(StoreManager storeMgr) {
        GenericObjectPool<PoolableConnection> connectionPool;
        String dbDriver = storeMgr.getConnectionDriverName();
        if (!StringUtils.isWhitespace((String)dbDriver)) {
            this.loadDriver(dbDriver, storeMgr.getNucleusContext().getClassLoaderResolver(null));
        }
        String dbURL = storeMgr.getConnectionURL();
        PoolingDataSource<PoolableConnection> ds = null;
        try {
            int value;
            int validationTimeout;
            Properties dbProps = DBCP2BuiltinConnectionPoolFactory.getPropertiesForDriver(storeMgr);
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(dbURL, dbProps);
            PoolableConnectionFactory poolableCF = null;
            poolableCF = new PoolableConnectionFactory(connectionFactory, null);
            String testSQL = null;
            if (storeMgr.hasProperty("datanucleus.connectionPool.testSQL")) {
                testSQL = storeMgr.getStringProperty("datanucleus.connectionPool.testSQL");
                poolableCF.setValidationQuery(testSQL);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.validationTimeout") && (validationTimeout = storeMgr.getIntProperty("datanucleus.connectionPool.validationTimeout")) >= 0) {
                poolableCF.setValidationQueryTimeout(validationTimeout);
            }
            connectionPool = new GenericObjectPool<PoolableConnection>(poolableCF);
            poolableCF.setPool(connectionPool);
            if (testSQL != null) {
                connectionPool.setTestOnBorrow(true);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxIdle") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.maxIdle")) > 0) {
                connectionPool.setMaxIdle(value);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.minIdle") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.minIdle")) > 0) {
                connectionPool.setMinIdle(value);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxActive") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.maxActive")) > 0) {
                connectionPool.setMaxTotal(value);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxWait") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.maxWait")) > 0) {
                connectionPool.setMaxWaitMillis(value);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.timeBetweenEvictionRunsMillis")) > 0) {
                connectionPool.setTimeBetweenEvictionRunsMillis(value);
                int maxIdle = connectionPool.getMaxIdle();
                int numTestsPerEvictionRun = (int)Math.ceil((double)maxIdle / 4.0);
                connectionPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis") && (value = storeMgr.getIntProperty("datanucleus.connectionPool.minEvictableIdleTimeMillis")) > 0) {
                connectionPool.setMinEvictableIdleTimeMillis(value);
            }
            ds = new PoolingDataSource<PoolableConnection>(connectionPool);
        }
        catch (Exception e) {
            throw new DatastorePoolException("DBCP2", dbDriver, dbURL, e);
        }
        return new DBCPConnectionPool(ds, connectionPool);
    }

    public class DBCPConnectionPool
    implements ConnectionPool {
        final PoolingDataSource dataSource;
        final GenericObjectPool<PoolableConnection> pool;

        public DBCPConnectionPool(PoolingDataSource ds, GenericObjectPool<PoolableConnection> pool) {
            this.dataSource = ds;
            this.pool = pool;
        }

        @Override
        public void close() {
            try {
                this.pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }
    }
}

