/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.smith.function;

import java.io.IOException;
import org.pageseeder.smith.ScoreFunction;
import org.pageseeder.smith.Scriptable;

public class LinearScore
implements ScoreFunction,
Scriptable {
    public static final LinearScore IDENTITY = new LinearScore();
    private final int _factor;

    public LinearScore() {
        this._factor = 1;
    }

    public LinearScore(int factor) {
        this._factor = factor;
    }

    public int factor() {
        return this._factor;
    }

    @Override
    public String type() {
        return "linear";
    }

    @Override
    public int get(int value) {
        return value * this._factor;
    }

    @Override
    public Appendable toScript(Appendable script) throws IOException {
        script.append("function (i) {");
        script.append(" return i * " + this._factor + ";");
        script.append("}");
        return script;
    }
}

