/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.aws;

import java.util.HashMap;
import java.util.Objects;
import net.pageseeder.aws.AmzDate;
import net.pageseeder.aws.AwsService;
import net.pageseeder.aws.Header;
import net.pageseeder.aws.Headers;
import net.pageseeder.aws.Parameters;
import net.pageseeder.aws.Payload;
import net.pageseeder.aws.Utils;

public class LiteAwsRequest {
    private final AwsService service;
    private final String method;
    private final String path;
    private final Headers headers;
    private final Parameters parameters;
    private final Payload payload;
    private final AmzDate date;

    private LiteAwsRequest(AwsService service, String method, Headers headers, String path, Parameters parameters, Payload payload, AmzDate date) {
        this.service = service;
        this.headers = headers;
        this.method = method;
        this.path = path;
        this.parameters = parameters;
        this.payload = payload;
        this.date = date;
    }

    LiteAwsRequest(AwsService service, String method, String path, Parameters parameters, Payload payload, AmzDate date) {
        this.service = service;
        this.headers = LiteAwsRequest.computeHeaders(service, payload, date);
        this.method = method;
        this.path = path;
        this.parameters = parameters;
        this.payload = payload;
        this.date = date;
    }

    public LiteAwsRequest(AwsService service, String method, String path, Parameters parameters, Payload payload) {
        this(service, method, path, parameters, payload, new AmzDate());
    }

    public static LiteAwsRequest newGetRequest(AwsService service, String path) {
        return new LiteAwsRequest(service, "GET", path, Parameters.empty(), Payload.empty());
    }

    public static LiteAwsRequest newGetRequest(AwsService service, String path, Parameters parameters) {
        return new LiteAwsRequest(service, "GET", path, parameters, Payload.empty());
    }

    public static LiteAwsRequest newPostRequest(AwsService service, String path, Payload payload) {
        return new LiteAwsRequest(service, "POST", path, Parameters.empty(), payload);
    }

    public static LiteAwsRequest newPutRequest(AwsService service, String path, Payload payload) {
        return new LiteAwsRequest(service, "PUT", path, Parameters.empty(), payload);
    }

    public LiteAwsRequest withDate(AmzDate date) {
        Headers updatedHeaders = this.headers.put("x-amz-date", date.toString());
        return new LiteAwsRequest(this.service, this.method, updatedHeaders, this.path, this.parameters, this.payload, date);
    }

    public LiteAwsRequest withHost(String host) {
        return this.withHeader(new Header("Host", host));
    }

    public LiteAwsRequest withHeader(String name, String value) {
        Headers updatedHeaders = this.headers.put(name, value);
        return new LiteAwsRequest(this.service, this.method, updatedHeaders, this.path, this.parameters, this.payload, this.date);
    }

    public LiteAwsRequest withHeader(Header header) {
        Headers updatedHeaders = this.headers.put(header);
        return new LiteAwsRequest(this.service, this.method, updatedHeaders, this.path, this.parameters, this.payload, this.date);
    }

    public LiteAwsRequest signContent() {
        Header header = new Header("x-amz-content-sha256", Utils.hash(this.payload.bytes()));
        Headers updatedHeaders = this.headers.put(header);
        return new LiteAwsRequest(this.service, this.method, updatedHeaders, this.path, this.parameters, this.payload, this.date);
    }

    private static Headers computeHeaders(AwsService service, Payload payload, AmzDate date) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", service.host());
        if (!payload.isEmpty()) {
            if (payload.hasMediaType()) {
                headers.put("Content-Type", payload.mediaType());
            }
            headers.put("x-amz-content-sha256", Utils.hash(payload.bytes()));
        }
        headers.put("x-amz-date", date.toString());
        return Headers.fromMap(headers);
    }

    public String host() {
        return Objects.toString(this.headers.getValue("Host"), this.service.host());
    }

    public String method() {
        return this.method;
    }

    public AwsService service() {
        return this.service;
    }

    public String path() {
        return this.path;
    }

    public Parameters parameters() {
        return this.parameters;
    }

    public boolean hasAuthorization() {
        return this.headers.get("Authorization") != null;
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public AmzDate amzDate() {
        return this.date;
    }

    public Payload payload() {
        return this.payload;
    }

    public boolean hasPayload() {
        return !this.payload.isEmpty();
    }

    public Headers headers() {
        return this.headers;
    }

    public String toUrl() {
        String url = "https://" + this.host() + this.path;
        if (this.hasParameters()) {
            url = url + "?" + this.parameters.toQueryString();
        }
        return url;
    }

    public String toString() {
        return "LiteAwsRequest{service=" + String.valueOf(this.service) + ", method='" + this.method + "', path='" + this.path + "', headers=" + String.valueOf(this.headers) + ", parameters=" + String.valueOf(this.parameters) + ", payload=" + String.valueOf(this.payload) + ", date=" + String.valueOf(this.date) + "}";
    }
}

