/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.utils;

import com.pageseeder.publishapi.ExternalConfig;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.eclipse.jdt.annotation.Nullable;

public final class ANTUtils {
    private ANTUtils() {
    }

    public static ExternalConfig buildConfig(Project project, @Nullable String config) {
        String jsessionid;
        String password;
        String csrfToken;
        String effectiveConfig = config == null ? "default" : config;
        ExternalConfig externalConfig = new ExternalConfig(effectiveConfig);
        String host = ANTUtils.getProperty(project, effectiveConfig, "host");
        if (host == null) {
            throw new BuildException("Invalid config, no host");
        }
        externalConfig.setHost(host);
        String port = ANTUtils.getProperty(project, effectiveConfig, "port");
        if (port == null) {
            throw new BuildException("Invalid config, no port");
        }
        externalConfig.setPort(port);
        String scheme = ANTUtils.getProperty(project, effectiveConfig, "scheme");
        if (scheme == null) {
            throw new BuildException("Invalid config, no scheme");
        }
        externalConfig.setScheme(scheme);
        String siteprefix = ANTUtils.getProperty(project, effectiveConfig, "site.prefix");
        if (siteprefix == null) {
            throw new BuildException("Invalid config, no site prefix");
        }
        externalConfig.setPSPrefix(siteprefix);
        String servletPrefix = ANTUtils.getProperty(project, effectiveConfig, "servlet.prefix");
        if (servletPrefix == null) {
            throw new BuildException("Invalid config, no servlet prefix");
        }
        externalConfig.setServletPrefix(servletPrefix);
        String username = ANTUtils.getProperty(project, effectiveConfig, "username");
        if (username == null) {
            throw new BuildException("Invalid config, no username");
        }
        externalConfig.setUsername(username);
        String userToken = ANTUtils.getProperty(project, effectiveConfig, "user.token");
        if (userToken != null) {
            externalConfig.setUserToken(userToken);
        }
        if ((csrfToken = ANTUtils.getProperty(project, effectiveConfig, "anticsrftoken")) != null) {
            externalConfig.setAntiCSRFToken(csrfToken);
        }
        if ((password = ANTUtils.getProperty(project, effectiveConfig, "password")) != null) {
            externalConfig.setPassword(password);
        }
        if ((jsessionid = ANTUtils.getProperty(project, effectiveConfig, "jsessionid")) != null) {
            externalConfig.setJSessionID(jsessionid);
        }
        String uriHost = ANTUtils.getProperty(project, effectiveConfig, "uri.host");
        String groupHost = ANTUtils.getProperty(project, effectiveConfig, "group.host");
        if (uriHost != null) {
            externalConfig.setUriHost(uriHost);
        } else if (groupHost != null) {
            externalConfig.setUriHost(groupHost);
        }
        return externalConfig;
    }

    private static @Nullable String getProperty(Project project, String config, String localName) {
        return project.getProperty("ps.config." + config + "." + localName);
    }
}

