/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.publish;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.Request;
import com.pageseeder.publishapi.publish.MessageType;
import com.pageseeder.publishapi.publish.PublishLogger;
import com.pageseeder.publishapi.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Publish {
    private static final int DEFAULT_POLLING_INTERVAL = 5000;
    private final ExternalConfig config;
    private final String groupname;
    private final String project;
    private final String action;
    private @Nullable String documenttype = null;
    private String loglevel = "info";
    private @Nullable String uri = null;
    private int pollingInterval = 5000;
    private @Nullable PublishLogger logger = null;
    private final Map<String, String> params = new HashMap<String, String>();

    public Publish(ExternalConfig config, String group, String project, String action) {
        this.config = config;
        this.groupname = group;
        this.project = project;
        if (!("import".equals(action) || "export".equals(action) || "preview".equals(action) || "publish".equals(action) || "process".equals(action))) {
            throw new IllegalArgumentException("Illegal type " + action);
        }
        this.action = action;
    }

    public void setLogLevel(@Nullable String level) {
        if (level == null) {
            this.loglevel = "info";
        } else if ("debug".equals(level) || "verbose".equals(level) || "info".equals(level) || "warn".equals(level) || "error".equals(level)) {
            this.loglevel = level;
        } else {
            throw new IllegalArgumentException("Illegal level " + level);
        }
    }

    public void setURI(@Nullable String uri) {
        this.uri = uri;
    }

    public void setParameter(String name, String value) {
        this.params.put(name, value);
    }

    public void setDocumentType(@Nullable String documenttype) {
        this.documenttype = documenttype;
    }

    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = this.pollingInterval <= 0 ? 5000 : pollingInterval;
    }

    public void setLogger(PublishLogger logger) {
        this.logger = logger;
    }

    public void publish(String target) throws PageseederException {
        String member = this.config.getUsername();
        if (member == null) {
            throw new PageseederException("No member in the config!");
        }
        Request start = new Request(Publish.buildStartServicePath(member, this.groupname, this.uri), this.config);
        start.addParameter("log-level", this.loglevel);
        start.addParameter("project", this.project);
        start.addParameter("type", this.action);
        start.addParameter("target", target);
        if (this.documenttype != null) {
            start.addParameter("documenttype", this.documenttype);
        }
        for (Map.Entry<String, String> param : this.params.entrySet()) {
            start.addParameter("ps-param-" + param.getKey(), param.getValue());
        }
        start.send();
        PublisherResponseHandler handler = this.parseResponse(start.getResponse());
        while (!Publish.isPublishCompleted(handler.status)) {
            try {
                Thread.sleep(this.pollingInterval);
            }
            catch (InterruptedException ex) {
                if (this.logger != null) {
                    this.logger.log("Failed to wait delay: " + ex.getMessage(), MessageType.ERROR);
                }
                throw new PageseederException("Failed to wait delay", ex);
            }
            Request check = new Request(Publish.buildCheckServicePath(member), this.config);
            check.addParameter("jobid", handler.id);
            check.send();
            handler = this.parseResponse(check.getResponse());
        }
    }

    private PublisherResponseHandler parseResponse(byte[] resp) throws PageseederException {
        PublisherResponseHandler handler = new PublisherResponseHandler(this.logger);
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        XMLUtils.parse(new ByteArrayInputStream(resp), handler, errors, warnings);
        if (this.logger != null) {
            for (String error : errors) {
                this.logger.log(error, MessageType.ERROR);
            }
            for (String warning : warnings) {
                this.logger.log(warning, MessageType.WARN);
            }
        }
        return handler;
    }

    private static String buildStartServicePath(String member, String group, @Nullable String uri) {
        return "/service/members/" + URLEncoder.encode(member, StandardCharsets.UTF_8).replace("+", "%20") + "/groups/" + group + (String)(uri != null ? "/uris/" + uri : "") + "/publish/start";
    }

    private static String buildCheckServicePath(String member) {
        return "/service/members/" + URLEncoder.encode(member, StandardCharsets.UTF_8).replace("+", "%20") + "/publish/check";
    }

    private static boolean isPublishCompleted(@Nullable String status) {
        return "complete".equals(status) || "cancel".equals(status) || "error".equals(status) || "fail".equals(status);
    }

    private static class PublisherResponseHandler
    extends DefaultHandler {
        private final @Nullable PublishLogger logger;
        private @Nullable String id = null;
        private @Nullable String status = null;
        private @Nullable XMLStringWriter messageContent = null;
        private @Nullable MessageType messageType = null;
        private @Nullable StringBuilder ch = null;

        public PublisherResponseHandler(@Nullable PublishLogger logger) {
            this.logger = logger;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.messageContent != null) {
                this.messageContent.openElement(uri, localName, true);
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.messageContent.attribute(atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                }
            } else if ("publish".equals(qName)) {
                this.id = atts.getValue("id");
            } else if ("status".equals(qName)) {
                this.ch = new StringBuilder();
            } else if ("message".equals(qName) && !"true".equals(atts.getValue("logged")) && this.logger != null) {
                this.messageType = MessageType.fromString(atts.getValue("type"));
                if (this.messageType != null) {
                    this.messageContent = new XMLStringWriter(XML.NamespaceAware.Yes);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (!"message".equals(qName) && this.messageContent != null) {
                this.messageContent.closeElement();
                return;
            }
            if ("message".equals(qName) && this.messageContent != null && this.messageType != null) {
                String msg = this.messageContent.toString().trim();
                if (!msg.isEmpty() && this.logger != null) {
                    this.logger.log(msg, this.messageType);
                }
                this.messageContent = null;
                this.messageType = null;
            } else if ("status".equals(qName) && this.ch != null) {
                this.status = this.ch.toString();
                this.ch = null;
            }
        }

        @Override
        public void characters(char[] str, int start, int length) {
            if (this.ch != null) {
                this.ch.append(str, start, length);
            } else if (this.messageContent != null) {
                this.messageContent.writeXML(str, start, length);
            }
        }
    }
}

