/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.publish;

import org.eclipse.jdt.annotation.Nullable;

public enum MessageType {
    TARGETSTART{

        public String toString() {
            return "target-start";
        }

        @Override
        public int getPriority() {
            return 2;
        }
    }
    ,
    TARGETEND{

        public String toString() {
            return "target-end";
        }

        @Override
        public int getPriority() {
            return 2;
        }
    }
    ,
    INFO{

        public String toString() {
            return "info";
        }

        @Override
        public int getPriority() {
            return 2;
        }
    }
    ,
    WARN{

        public String toString() {
            return "warn";
        }

        @Override
        public int getPriority() {
            return 1;
        }
    }
    ,
    DEBUG{

        public String toString() {
            return "debug";
        }

        @Override
        public int getPriority() {
            return 4;
        }
    }
    ,
    INPROGRESS{

        public String toString() {
            return "in-progress";
        }

        @Override
        public int getPriority() {
            return 3;
        }
    }
    ,
    COMPLETE{

        public String toString() {
            return "complete";
        }

        @Override
        public int getPriority() {
            return 2;
        }
    }
    ,
    ERROR{

        public String toString() {
            return "error";
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }
    ,
    FAIL{

        public String toString() {
            return "fail";
        }

        @Override
        public int getPriority() {
            return 0;
        }
    }
    ,
    CANCEL{

        public String toString() {
            return "cancel";
        }

        @Override
        public int getPriority() {
            return 2;
        }
    };


    public abstract int getPriority();

    public boolean isHigherPriority(int priority) {
        return this.getPriority() > priority;
    }

    public static @Nullable MessageType fromString(@Nullable String s) {
        if (s == null) {
            return null;
        }
        for (MessageType t : MessageType.values()) {
            if (!s.equals(t.toString())) continue;
            return t;
        }
        return null;
    }
}

