/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.oauth;

import com.pageseeder.publishapi.oauth.OAuthUtils;
import com.pageseeder.publishapi.oauth.TokenResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class TokenRequest {
    private static final String TOKEN_ENDPOINT = "/oauth/token";
    private final String url;
    private final Map<String, String> parameters;
    private final String clientId;
    private final String clientSecret;

    private TokenRequest(String url, Map<String, String> parameters, String clientId, String clientSecret) {
        this.url = url;
        this.parameters = parameters;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public static TokenRequest newClientCredentials(String clientId, String clientSecret, String urlBase) {
        Objects.requireNonNull(clientId, "The client credentials are required (ID)");
        Objects.requireNonNull(clientSecret, "The client credentials are required (secret)");
        Objects.requireNonNull(urlBase, "The url base is required");
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>(3);
        parameters.put("grant_type", "client_credentials");
        return new TokenRequest(urlBase + TOKEN_ENDPOINT, parameters, clientId, clientSecret);
    }

    public TokenResponse post() {
        try {
            URL urlInstance = new URL(this.url);
            HttpURLConnection connection = (HttpURLConnection)urlInstance.openConnection();
            String authorization = Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes(StandardCharsets.UTF_8));
            connection.addRequestProperty("Authorization", "Basic " + authorization);
            connection.setRequestMethod("POST");
            byte[] encodedParameters = OAuthUtils.encodeParameters(this.parameters).getBytes(StandardCharsets.UTF_8);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            connection.setRequestProperty("Content-Length", Integer.toString(encodedParameters.length));
            connection.setDoInput(true);
            connection.setDoOutput(true);
            try (OutputStream post = connection.getOutputStream();){
                post.write(encodedParameters);
                post.flush();
            }
            return TokenResponse.consume(connection, this.clientSecret);
        }
        catch (ConnectException ex) {
            return TokenResponse.error("connection_error", ex.getMessage());
        }
        catch (ProtocolException ex) {
            return TokenResponse.error("protocol_error", ex.getMessage());
        }
        catch (IOException ex) {
            return TokenResponse.error("io_error", ex.getMessage());
        }
    }

    public String toString() {
        return "POST " + this.url + "?" + OAuthUtils.encodeParameters(this.parameters).replaceAll("password=([^&]+)", "password=******");
    }
}

