/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant.export;

import com.pageseeder.publishapi.Export;
import com.pageseeder.publishapi.ant.AntLogger;
import com.pageseeder.publishapi.ant.export.Filter;
import com.pageseeder.publishapi.ant.export.XRefs;
import com.pageseeder.publishapi.utils.ANTUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.jdt.annotation.Nullable;

public final class ExportTask
extends Task {
    private @Nullable String src = null;
    private @Nullable String group = null;
    private @Nullable String dest = null;
    private @Nullable String srcuris = null;
    private @Nullable String context = null;
    private @Nullable String includes = null;
    private @Nullable String excludes = null;
    private String config = "default";
    private boolean failOnError = true;
    private boolean metadataOnly = false;
    private boolean binaryMetadataOnly = false;
    private boolean allUrls = false;
    private boolean interpublicationXrefs = false;
    private boolean independent = false;
    private boolean loadImages = true;
    private boolean loadAlternates = true;
    private @Nullable String compareVersion = null;
    private @Nullable String versionName = null;
    private @Nullable String publicationid = null;
    private int position = 1;
    private boolean processPublication = false;
    private @Nullable Filter filter = null;
    private int forward = 0;
    private @Nullable XRefs xrefs = null;

    public void setCompareTo(String compare) {
        this.compareVersion = compare;
    }

    public void setVersion(@Nullable String release) {
        this.versionName = release == null || release.isEmpty() ? null : release;
    }

    public void setPublicationID(@Nullable String id) {
        this.publicationid = id == null || id.isEmpty() ? null : id;
    }

    public void setPosition(int pos) {
        this.position = pos;
    }

    public void setProcessPublication(boolean process) {
        this.processPublication = process;
    }

    public void setLoadImages(boolean load) {
        this.loadImages = load;
    }

    public void setAllurls(boolean allurls) {
        this.allUrls = allurls;
    }

    public void setInterpublicationXrefs(boolean resolve) {
        this.interpublicationXrefs = resolve;
    }

    public void setIndependent(boolean ind) {
        this.independent = ind;
    }

    public void setLoadAlternates(boolean load) {
        this.loadAlternates = load;
    }

    public void setXRefDepth(int depth) {
        this.forward = depth;
    }

    public XRefs createXRefs() {
        this.xrefs = new XRefs();
        return this.xrefs;
    }

    public Filter createFilter() {
        this.filter = new Filter();
        return this.filter;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setConfig(@Nullable String config) {
        this.config = config == null || config.isEmpty() ? null : config;
    }

    public void setContext(@Nullable String context) {
        this.context = context == null || context.isEmpty() ? null : context;
    }

    public void setDest(@Nullable String destination) {
        this.dest = destination == null || destination.isEmpty() ? null : destination;
    }

    public void setExcludes(@Nullable String exc) {
        this.excludes = exc == null || exc.isEmpty() ? null : exc;
    }

    public void setIncludes(@Nullable String inc) {
        this.includes = inc == null || inc.isEmpty() ? null : inc;
    }

    public void setMetadataOnly(boolean metadataonly) {
        this.metadataOnly = metadataonly;
    }

    public void setBinaryMetadataOnly(boolean binarymetadataonly) {
        this.binaryMetadataOnly = binarymetadataonly;
    }

    public void setSrc(@Nullable String source) {
        this.src = source == null || source.isEmpty() ? null : source;
    }

    public void setSrcuris(@Nullable String srcURIs) {
        this.srcuris = srcURIs == null || srcURIs.isEmpty() ? null : srcURIs;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void execute() throws BuildException {
        if (this.src == null && this.srcuris == null && (this.context == null || this.group == null)) {
            throw new BuildException("One of src, srcuris or (context and group) must be specified");
        }
        if (this.src != null && this.srcuris != null) {
            throw new BuildException("Only one of src or srcuris can be specified");
        }
        if (this.srcuris != null && this.context == null) {
            throw new BuildException("Context must be specified if srcuris is used");
        }
        if (this.forward != 0 && this.xrefs != null && this.xrefs.getForward() != 0) {
            throw new BuildException("XRefs forward depth cannot be specified twice as an attribute and as an inner element");
        }
        if (this.filter != null && this.filter.getIndexComplete() && this.group == null) {
            throw new BuildException("Group must be specified if indexcomplete is used");
        }
        Export export = new Export();
        export.setLogger(AntLogger.newInstance(this));
        export.setSource(this.src);
        export.setSourceURIs(this.srcuris);
        export.setContext(this.context);
        export.setDestination(this.dest);
        export.setIncludesExcludes(this.includes, this.excludes);
        export.setMetadataOnly(this.metadataOnly, this.binaryMetadataOnly);
        export.setAllUrls(this.allUrls);
        export.setInterpublicationXrefs(this.interpublicationXrefs);
        export.setIndependent(this.independent);
        export.setLoadDetails(this.loadImages, this.loadAlternates);
        export.setFailOnError(this.failOnError);
        export.setCompare(this.compareVersion);
        export.setGroup(this.group);
        export.setRelease(this.versionName);
        export.setPublication(this.publicationid, this.processPublication, this.position);
        if (this.filter != null) {
            export.setFiltering(this.filter.getWith(), this.filter.getWithout(), this.filter.getSince(), this.filter.getRanges(), this.filter.getIndexComplete());
        }
        if (this.xrefs != null) {
            export.setXRefDepths(this.xrefs.getForward(), this.xrefs.getReverse());
            export.setXRefTypes(this.xrefs.getTypes());
        }
        if (this.forward > 0) {
            export.setXRefDepths(this.forward, 0);
        }
        try {
            export.export(ANTUtils.buildConfig(this.getProject(), this.config));
        }
        catch (Throwable e) {
            throw new BuildException("Failed to export: " + e.getMessage(), e);
        }
    }
}

