/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi.ant;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.LoadingZoneGet;
import com.pageseeder.publishapi.utils.ANTUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.jdt.annotation.Nullable;

public class LoadingZoneGetTask
extends Task {
    private @Nullable String path = null;
    private @Nullable String paths = null;
    private @Nullable String destination = null;
    private @Nullable String group = null;
    private String config = "default";
    private boolean failOnError = true;
    private boolean subfolders = true;

    public void setPath(String path) {
        this.path = path;
    }

    public void setPaths(String paths) {
        this.paths = paths;
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setSubfolders(boolean yes) {
        this.subfolders = yes;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void execute() throws BuildException {
        List<Object> errors;
        if (this.path == null && this.paths == null) {
            throw new BuildException("Path to download is not specified.");
        }
        if (this.group == null) {
            throw new BuildException("Group is not specified.");
        }
        if (this.destination == null) {
            throw new BuildException("Please specify a destination directory.");
        }
        if (this.path != null) {
            errors = this.downloadPath(this.path);
        } else {
            String[] steps;
            errors = new ArrayList();
            for (String step : steps = this.paths.split("\\|")) {
                if (step.endsWith("/")) {
                    this.log("Path " + step + " is ignored as it points to a folder.", 1);
                    continue;
                }
                errors.addAll(this.downloadPath(step));
            }
        }
        while (!errors.isEmpty()) {
            this.log((String)errors.remove(0), 0);
        }
    }

    private List<String> downloadPath(String thepath) {
        assert (this.destination != null && this.group != null);
        ArrayList<String> errors = new ArrayList<String>();
        File whereTo = new File(this.destination);
        int i = thepath.lastIndexOf("/");
        String filename = i != -1 ? thepath.substring(i + 1) : thepath;
        File saveAs = new File(whereTo, this.subfolders ? thepath : filename);
        try {
            ExternalConfig psconfig = ANTUtils.buildConfig(this.getProject(), this.config);
            LoadingZoneGet lzg = new LoadingZoneGet(thepath, this.group, psconfig);
            whereTo.mkdirs();
            if (!whereTo.exists()) {
                throw new BuildException("Could not create destination directory: " + whereTo.getAbsolutePath());
            }
            saveAs.getParentFile().mkdirs();
            if (!saveAs.exists() && !saveAs.createNewFile()) {
                throw new BuildException("Could not create local file " + saveAs.getAbsolutePath());
            }
            lzg.saveAs(saveAs);
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new BuildException("Failed to download the path " + thepath + ": " + e.getMessage(), (Throwable)e);
            }
            this.log("Failed to download the path " + thepath + ": " + e.getMessage(), 2);
            saveAs.delete();
        }
        return errors;
    }
}

