/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi;

import com.pageseeder.publishapi.ExternalConfig;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.publishapi.Request;
import com.pageseeder.publishapi.utils.ResponseHandler;
import com.pageseeder.publishapi.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;

public class MultiPartRequest {
    private static final SimpleDateFormat LOGGER_SDF = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss");
    private final Logger logger = Logger.getLogger("PageseederAPI");
    private final ExternalConfig config;
    private final String servletName;
    private @Nullable HttpURLConnection connection;
    private @Nullable DataOutputStream out = null;
    private static final String BOUNDARY = "-----------7d32a512502e0";
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    public MultiPartRequest(ExternalConfig cfg, String servlet, Map<String, Object> params) throws PageseederException {
        this(cfg, servlet, params, true, true);
    }

    public MultiPartRequest(ExternalConfig cfg, String servlet, Map<String, Object> params, boolean useServletPrefix, boolean usePSPrefix) throws PageseederException {
        this(cfg, servlet, params, useServletPrefix, usePSPrefix, true, -1);
    }

    public MultiPartRequest(ExternalConfig config, String servlet) {
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet name cannot be null");
        }
        this.config = config;
        this.servletName = (!servlet.startsWith("/") ? "/" : "") + servlet;
    }

    public MultiPartRequest(ExternalConfig config, String servlet, @Nullable Map<String, Object> params, boolean useServletPrefix, boolean usePSPrefix, boolean connect, int chunkSize) throws PageseederException {
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet name cannot be null");
        }
        this.config = config;
        this.servletName = (!servlet.startsWith("/") ? "/" : "") + servlet;
        if (params != null) {
            this.parameters.putAll(params);
        }
        if (connect) {
            this.connect(useServletPrefix, usePSPrefix, chunkSize);
        }
    }

    public void addParameter(@Nullable String name, @Nullable String value) {
        if (name != null && value != null) {
            this.parameters.put(name, value);
        }
    }

    public void connect(boolean useServletPrefix, boolean usePSPrefix, int chunkSize) throws PageseederException {
        String prefix = "";
        if (useServletPrefix) {
            prefix = this.config.getServletPrefix();
        } else if (usePSPrefix) {
            prefix = this.config.getPSPrefix();
        }
        String uriString = prefix + this.servletName + (this.servletName.indexOf(63) == -1 ? "?" : "&");
        if (this.parameters != null) {
            uriString = uriString + MultiPartRequest.toQueryString(this.parameters);
        }
        if (this.config.getJSessionID() == null && !"jsessionid".equals(this.config.getUsername()) && this.config.getUsername() != null && this.config.getPassword() != null) {
            uriString = uriString + "&username=" + URLEncoder.encode(this.config.getUsername(), StandardCharsets.UTF_8);
            uriString = uriString + "&password=" + URLEncoder.encode(this.config.getPassword(), StandardCharsets.UTF_8);
        }
        boolean tryBackup = this.config.getBackupHost() != null && this.config.getNbOfTries() > 0;
        int tries = 1;
        boolean useBackup = false;
        while (true) {
            try {
                this.connectToUrl(uriString, useBackup, chunkSize);
            }
            catch (IOException e) {
                if (tryBackup) {
                    if (tries < this.config.getNbOfTries()) {
                        this.logger.warning("Connecting to master pageseeder failed on attempt number " + ++tries);
                        continue;
                    }
                    if (!useBackup) {
                        this.logger.warning("Connecting to master pageseeder failed on attempt number " + tries);
                        this.logger.warning("Changing to slave pageseeder after failing master pageseeder " + tries + " times");
                        useBackup = true;
                        continue;
                    }
                }
                this.logger.severe("Error connecting to the Pageseeder server: " + e.getMessage());
                throw new PageseederException("Error connecting to the Pageseeder server: " + Utils.removePasswordJsessionid(e.getMessage()), e);
            }
            break;
        }
        try {
            this.out = new DataOutputStream(this.connection.getOutputStream());
        }
        catch (Exception e) {
            this.logger.severe("Error writing the request to the Pageseeder server: " + e.getMessage());
            throw new PageseederException("Error writing the request to the Pageseeder server: " + Utils.removePasswordJsessionid(e.getMessage()), e);
        }
        this.logger.finest(LOGGER_SDF.format(new Date()) + " Connected");
        this.logger.finest("--------MultiPart request----------");
    }

    private void connectToUrl(String uriString, boolean useBackup, int chunkSize) throws IOException {
        String host = useBackup ? this.config.getBackupHost() : this.config.getHost();
        int port = useBackup ? this.config.getBackupPort() : this.config.getPort();
        String scheme = this.config.getScheme() != null ? this.config.getScheme() : "http";
        URL url = new URL(scheme + "://" + host + ":" + port + uriString);
        this.logger.finest("--------MultiPart request----------");
        this.logger.finest(LOGGER_SDF.format(new Date()) + " URL to connect to is " + String.valueOf(url));
        this.connection = (HttpURLConnection)url.openConnection();
        if (chunkSize >= 0) {
            this.connection.setChunkedStreamingMode(chunkSize);
        }
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
        this.connection.setRequestProperty("User-Agent", "Pageseeder External API " + Request.class.getPackage().getImplementationVersion());
        this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=-----------7d32a512502e0");
        this.connection.setRequestMethod("POST");
        if (this.config.getUserToken() != null) {
            this.connection.setRequestProperty("Authorization", "Bearer " + this.config.getUserToken());
        } else if (this.config.getJSessionID() != null) {
            this.connection.setRequestProperty("Cookie", "JSESSIONID=" + this.config.getJSessionID());
            if (this.config.getAntiCSRFToken() != null) {
                this.connection.setRequestProperty("Anti-CSRF-Token", this.config.getAntiCSRFToken());
            }
        }
        this.connection.connect();
    }

    private void writeBytes(DataOutputStream dout, String s) throws IOException {
        dout.write(s.getBytes(StandardCharsets.UTF_8));
    }

    public void addPart(byte[] content, String encoding, String contentType, @Nullable Map<String, String> headers) throws PageseederException {
        this.addPart(new ByteArrayInputStream(content), encoding, contentType, headers);
    }

    public void addPart(InputStream in, String encoding, String contentType, @Nullable Map<String, String> headers) throws PageseederException {
        if (this.out == null) {
            throw new PageseederException("Connection to Pageseeder server failed or closed, cannot send file");
        }
        try {
            int bytesRead;
            this.writeBytes(this.out, "-------------7d32a512502e0\r\n");
            if (headers != null) {
                for (String hname : headers.keySet()) {
                    if (hname.toLowerCase().equals("content-type")) continue;
                    this.writeBytes(this.out, hname + ": " + headers.get(hname) + "\r\n");
                }
            }
            this.writeBytes(this.out, "Content-Type: " + contentType + "; charset=\"" + encoding + "\"\r\n\r\n");
            this.logger.finest("--------MultiPart addPart----------");
            this.logger.finest(LOGGER_SDF.format(new Date()) + " Writing new Part with encoding " + encoding);
            this.logger.finest("--------MultiPart addPart----------");
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                this.out.write(buffer, 0, bytesRead);
            }
            this.writeBytes(this.out, "\r\n");
            this.out.flush();
        }
        catch (IOException e) {
            if (this.logger.isLoggable(Level.FINEST)) {
                e.printStackTrace(System.out);
            }
            this.logger.severe("Error writing a part to the request to the Pageseeder server: " + e.getMessage());
            throw new PageseederException("Error writing a Part", e);
        }
    }

    public void addPart(@Nullable String content, String contentType, @Nullable Map<String, String> headers) throws PageseederException {
        if (content == null) {
            return;
        }
        this.addPart(content.getBytes(StandardCharsets.UTF_8), "UTF-8", contentType, headers);
    }

    public void addPart(String content, String contentType) throws PageseederException {
        this.addPart(content, contentType, null);
    }

    public void addXMLPart(String content) throws PageseederException {
        this.addPart(content, "text/xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResponse() throws PageseederException {
        StringBuilder response;
        block32: {
            int status;
            try {
                if (this.out != null) {
                    this.writeBytes(this.out, "-------------7d32a512502e0--\r\n");
                    this.out.flush();
                    this.out.close();
                }
            }
            catch (IOException e) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    e.printStackTrace(System.out);
                }
                this.logger.severe("Error disconnecting from the Pageseeder server: " + e.getMessage());
                throw new PageseederException("Error disconnecting from the Pageseeder server", e);
            }
            this.out = null;
            String message = null;
            try {
                status = this.connection.getResponseCode();
                message = this.connection.getResponseMessage();
            }
            catch (IOException e) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    e.printStackTrace(System.out);
                }
                this.logger.severe("Error reading the response from the Pageseeder server: " + e.getMessage());
                throw new PageseederException("Error reading response from the Pageseeder server", e);
            }
            this.updateExternalConfig();
            this.logger.finest("--------Upload:getResponse----------");
            this.logger.finest(LOGGER_SDF.format(new Date()) + " HTTP Status code read: " + status);
            response = new StringBuilder();
            InputStream responseStream = null;
            try {
                String encoding = this.connection.getContentEncoding();
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                responseStream = status != 200 ? this.connection.getErrorStream() : this.connection.getInputStream();
                byte[] buff = new byte[1024];
                if (responseStream != null) {
                    int read;
                    while ((read = responseStream.read(buff)) != -1) {
                        response.append(new String(buff, 0, read, encoding));
                    }
                }
            }
            catch (IOException e) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    e.printStackTrace(System.out);
                }
                this.logger.severe("Error reading response from the Pageseeder server: " + e.getMessage());
                if (status == 200) {
                    throw new PageseederException("Error reading response from the Pageseeder server", e);
                }
            }
            finally {
                if (responseStream != null) {
                    try {
                        responseStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            this.logger.finest(LOGGER_SDF.format(new Date()) + " Response read");
            this.logger.finest("--------Upload:getResponse----------");
            try {
                ResponseHandler handler;
                block33: {
                    if (status == 200) break block32;
                    handler = null;
                    if (this.isXMLResponse() && response.length() > 0) {
                        try {
                            handler = ResponseHandler.readResponse(response.toString());
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            if (!this.logger.isLoggable(Level.FINEST)) break block33;
                            ex.printStackTrace(System.out);
                        }
                    }
                }
                String error = handler != null && handler.getMessage() != null ? handler.getMessage() : message;
                PageseederException exc = new PageseederException("HTTP Status: " + status + (String)(handler != null && handler.getErrorID() != null ? ", Error ID: " + handler.getErrorID() : "") + (String)(error != null ? ", Error message: " + error : "") + ", URL: " + Utils.removePasswordJsessionid(this.connection.getURL().toString()));
                exc.setResponse(response.toString());
                exc.setHttpStatus(status);
                if (handler != null) {
                    exc.setDate(handler.getDate());
                    exc.setPSStackTrace(handler.getStacktrace());
                }
                throw exc;
            }
            finally {
                this.connection.disconnect();
                this.connection = null;
            }
        }
        return response.toString();
    }

    private void updateExternalConfig() {
        assert (this.connection != null);
        String cookie = this.connection.getHeaderField("Set-Cookie");
        if (cookie == null) {
            return;
        }
        for (String ck : cookie.split(";")) {
            @Nullable String[] pair = ck.split("=");
            if (pair.length <= 1 || pair[0] == null || !"jsessionid".equalsIgnoreCase(pair[0]) || pair[1] == null || pair[1].isEmpty()) continue;
            this.config.setJSessionID(pair[1]);
            break;
        }
    }

    public ExternalConfig getConfig() {
        return this.config;
    }

    protected boolean isXMLResponse() {
        assert (this.connection != null);
        String type = this.connection.getContentType();
        if (type != null) {
            int i = type.indexOf(";");
            if (i != -1) {
                type = type.substring(0, i);
            }
            return type.endsWith("/xml") || type.endsWith("+xml");
        }
        return false;
    }

    private static String toQueryString(Map<String, Object> parameters) {
        ArrayList<String> pairs = new ArrayList<String>();
        for (Map.Entry<String, Object> p : parameters.entrySet()) {
            String name = p.getKey();
            Object value = p.getValue();
            if (value instanceof String[]) {
                String[] array;
                for (String element : array = (String[])value) {
                    pairs.add(MultiPartRequest.encodeParameter(name, element));
                }
                continue;
            }
            pairs.add(MultiPartRequest.encodeParameter(name, value.toString()));
        }
        return String.join((CharSequence)"&", pairs);
    }

    private static String encodeParameter(String name, String value) {
        return URLEncoder.encode(name, StandardCharsets.UTF_8) + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8);
    }
}

