/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publishapi;

import com.pageseeder.publishapi.PageseederException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.jdt.annotation.Nullable;

public class ExternalConfig {
    private static final String BACKUP_PORT_PROPERTY = "backupport";
    private static final String NB_OF_TRIES_PROPERTY = "nbOfTries";
    private static final String JSESSIONID_PROPERTY = "jsessionid";
    private static final String DELAY_BETWEEN_TRIES_PROPERTY = "delayBetweenTries";
    private final String name;
    private final Properties properties = new Properties();

    public ExternalConfig() {
        this("default");
    }

    public ExternalConfig(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void loadFromFile(String filename) throws PageseederException {
        block16: {
            if (!((String)filename).endsWith(".properties")) {
                filename = (String)filename + ".properties";
            }
            Object fn = null;
            try {
                if (new File((String)filename).exists()) {
                    fn = new File((String)filename).getName();
                    try (FileInputStream in = new FileInputStream((String)filename);){
                        this.properties.load(in);
                        break block16;
                    }
                }
                fn = filename;
                try (InputStream in = this.getClass().getResourceAsStream("/" + (String)filename);){
                    this.properties.load(in);
                }
            }
            catch (FileNotFoundException ex) {
                throw new PageseederException("Properties file " + fn + " not found", ex);
            }
            catch (Exception ex) {
                throw new PageseederException("Error reading properties file " + fn, ex);
            }
        }
    }

    public String getHost() {
        return this.properties.getProperty("host");
    }

    public void setHost(String host) {
        this.properties.setProperty("host", host);
    }

    public String getBackupHost() {
        return this.properties.getProperty("backupHost");
    }

    public void setBackupHost(String host) {
        this.properties.setProperty("backupHost", host);
    }

    public @Nullable String getUriHost() {
        return this.properties.getProperty("uriHost");
    }

    public void setUriHost(String host) {
        this.properties.setProperty("uriHost", host);
    }

    public @Nullable String getScheme() {
        return this.properties.getProperty("scheme");
    }

    public void setScheme(String scheme) {
        this.properties.setProperty("scheme", scheme);
    }

    public @Nullable String getJSessionID() {
        String js = this.properties.getProperty(JSESSIONID_PROPERTY);
        if (js != null && js.isEmpty()) {
            js = null;
        }
        if (js == null && JSESSIONID_PROPERTY.equals(this.getUsername())) {
            return this.getPassword();
        }
        return js;
    }

    public void setJSessionID(@Nullable String jsessionid) {
        if (jsessionid != null && jsessionid.isEmpty()) {
            jsessionid = null;
        }
        this.properties.setProperty(JSESSIONID_PROPERTY, jsessionid);
    }

    public int getNbOfTries() {
        if (this.properties.getProperty(NB_OF_TRIES_PROPERTY) == null) {
            return 0;
        }
        return Integer.parseInt(this.properties.getProperty(NB_OF_TRIES_PROPERTY));
    }

    public void setNbOfTries(String nbOfTries) {
        this.properties.setProperty(NB_OF_TRIES_PROPERTY, nbOfTries);
    }

    public long getDelayBetweenTries() {
        if (this.properties.getProperty(DELAY_BETWEEN_TRIES_PROPERTY) == null) {
            return 0L;
        }
        return Long.parseLong(this.properties.getProperty(DELAY_BETWEEN_TRIES_PROPERTY)) * 1000L;
    }

    public void setDelayBetweenTries(String delay) {
        this.properties.setProperty(DELAY_BETWEEN_TRIES_PROPERTY, delay);
    }

    public int getPort() {
        return Integer.parseInt(this.properties.getProperty("port"));
    }

    public void setPort(String port) {
        this.properties.setProperty("port", port);
    }

    public int getBackupPort() {
        if (this.properties.getProperty(BACKUP_PORT_PROPERTY) == null) {
            return this.getPort();
        }
        return Integer.parseInt(this.properties.getProperty(BACKUP_PORT_PROPERTY));
    }

    public void setBackupPort(String port) {
        this.properties.setProperty(BACKUP_PORT_PROPERTY, port);
    }

    public @Nullable String getUsername() {
        return this.properties.getProperty("username");
    }

    public void setUsername(String username) {
        this.properties.setProperty("username", username);
    }

    public @Nullable String getAntiCSRFToken() {
        return this.properties.getProperty("antiCSRFToken");
    }

    public void setAntiCSRFToken(String token) {
        this.properties.setProperty("antiCSRFToken", token);
    }

    public @Nullable String getUserToken() {
        return this.properties.getProperty("userToken");
    }

    public void setUserToken(String usertoken) {
        this.properties.setProperty("userToken", usertoken);
    }

    public @Nullable String getPassword() {
        return this.properties.getProperty("password");
    }

    public void setPassword(String password) {
        this.properties.setProperty("password", password);
    }

    public String getServletPrefix() {
        String sp = this.properties.getProperty("servletPrefix");
        if (sp != null && sp.startsWith(this.getPSPrefix() + "/")) {
            return sp;
        }
        return this.getPSPrefix() + sp;
    }

    public void setServletPrefix(String servletPrefix) {
        this.properties.setProperty("servletPrefix", servletPrefix);
    }

    public String getPSPrefix() {
        return this.properties.getProperty("psPrefix");
    }

    public void setPSPrefix(String prefix) {
        this.properties.setProperty("psPrefix", prefix);
    }
}

