/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.util;

import com.pageseeder.common.util.Strings;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.ObjectProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class Labels {
    private Labels() {
    }

    public static String[] toArray(@Nullable String labels) {
        if (labels == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(Strings.split((String)labels, (char)',')).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
    }

    public static void setLabels(@Nullable URI uri, String @Nullable [] labels) {
        if (uri == null) {
            return;
        }
        uri.setLabels(Labels.labelsToCommaSeparated(labels));
    }

    public static void setLabels(@Nullable XLink xl, String @Nullable [] labels) {
        if (xl == null) {
            return;
        }
        ObjectProperties.setXLinkProperty(xl, "label", labels == null ? null : Arrays.asList(labels));
    }

    public static void addLabels(@Nullable URI uri, String @Nullable [] labels) {
        if (uri == null || labels == null || labels.length == 0) {
            return;
        }
        Labels.setLabels(uri, Labels.merge(Labels.getLabels(uri), labels));
    }

    public static void addLabels(@Nullable XLink xl, String @Nullable [] labels) {
        if (xl == null || labels == null || labels.length == 0) {
            return;
        }
        Labels.setLabels(xl, Labels.merge(Labels.getLabels(xl), labels));
    }

    static @Nullable String[] merge(String @Nullable [] existing, String @Nullable [] labels) {
        String[] toSet;
        if (existing == null || existing.length == 0) {
            toSet = labels;
        } else if (labels == null || labels.length == 0) {
            toSet = existing;
        } else {
            ArrayList<String> labs = new ArrayList<String>();
            Collections.addAll(labs, existing);
            for (String label : labels) {
                if (labs.contains(label)) continue;
                labs.add(label);
            }
            toSet = labs.toArray(new String[0]);
        }
        return toSet;
    }

    public static void removeLabels(@Nullable URI uri, String @Nullable [] labels) {
        if (uri == null || labels == null || labels.length == 0) {
            return;
        }
        Labels.setLabels(uri, Labels.subtract(Labels.getLabels(uri), labels));
    }

    public static void removeLabels(@Nullable XLink xl, String @Nullable [] labels) {
        if (xl == null || labels == null || labels.length == 0) {
            return;
        }
        Labels.setLabels(xl, Labels.subtract(Labels.getLabels(xl), labels));
    }

    protected static String[] subtract(String @Nullable [] existing, String @Nullable [] labels) {
        if (existing == null || existing.length == 0) {
            return new String[0];
        }
        List<String> toremove = Arrays.asList(labels);
        ArrayList<String> newlabs = new ArrayList<String>();
        for (String label : existing) {
            if (toremove.contains(label)) continue;
            newlabs.add(label);
        }
        return newlabs.toArray(new String[0]);
    }

    public static @Nullable String labelsToCommaSeparated(String @Nullable [] labels) {
        if (labels == null || labels.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String label : labels) {
            if (label.isEmpty()) continue;
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(label);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    public static String[] getLabels(@Nullable XLink xl) {
        if (xl == null) {
            return new String[0];
        }
        return Labels.getLabelsFromProperties(xl.getProperties()).toArray(new String[0]);
    }

    public static String[] getLabels(@Nullable URI uri) {
        if (uri == null) {
            return new String[0];
        }
        return Labels.toArray(uri.getLabels());
    }

    private static List<String> getLabelsFromProperties(@Nullable String props) {
        ArrayList<String> labels = new ArrayList<String>();
        if (props == null) {
            return labels;
        }
        Map<String, List<String>> properties = ObjectProperties.toMap(props);
        List<String> values = properties.get("label");
        if (values != null) {
            labels.addAll(values);
        }
        return labels;
    }

    public static List<String> getEventLabelsFromProperties(@Nullable String props) {
        ArrayList<String> labels = new ArrayList<String>();
        if (props == null) {
            return labels;
        }
        Map<String, List<String>> properties = ObjectProperties.toMap(props);
        List<String> values = properties.get("event-label");
        if (values != null) {
            labels.addAll(values);
        }
        return labels;
    }

    public static boolean labelsAreDifferent(String @Nullable [] oldLabels, String @Nullable [] newLabels) {
        if (oldLabels == null) {
            return newLabels != null && newLabels.length > 0;
        }
        if (newLabels == null) {
            return oldLabels.length > 0;
        }
        if (oldLabels.length != newLabels.length) {
            return true;
        }
        block0: for (String newLabel : newLabels) {
            for (String oldLabel : oldLabels) {
                if (newLabel.equals(oldLabel)) continue block0;
            }
            return true;
        }
        return false;
    }
}

