/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.oauth;

import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.oauth.OAuthQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentTokenPurgeThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistentTokenPurgeThread.class);
    private static final int EXPIRED_DAYS = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int refresh = 0;
        int persistent = 0;
        Database db = null;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            LOGGER.error("Unable to open database", (Throwable)ex);
            db = null;
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            tr.begin();
            refresh = OAuthQuery.purgeRefreshTokens(db);
            persistent = OAuthQuery.purgePersistentTokens(db, 30);
            tr.commit();
        }
        catch (StartTransactionException ex) {
            LOGGER.error("Unable to start transaction", (Throwable)ex);
        }
        catch (DatabaseException ex) {
            LOGGER.error("Database error", (Throwable)ex);
            tr.abort();
        }
        finally {
            db.close();
            db = null;
        }
        if (refresh > 0) {
            LOGGER.info("Removed {} expired refresh tokens.", (Object)refresh);
        }
        if (persistent > 0) {
            LOGGER.info("Removed {} expired persistent tokens.", (Object)persistent);
        }
    }
}

