/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.model;

import com.pageseeder.db.CreateFailedException;
import com.pageseeder.db.Database;
import com.pageseeder.db.InsertFailedException;
import com.pageseeder.db.PSQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.Helper;
import com.pageseeder.db.model.MemberForGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import javax.jdo.JDOFatalInternalException;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;
import org.eclipse.jdt.annotation.Nullable;

public final class Member
extends DBObject
implements Persistable {
    public static final String NO_EMAIL = "No Email";
    private @Nullable String firstName;
    private @Nullable String surname;
    private @Nullable String email;
    private @Nullable String emailDomain;
    private String username;
    private @Nullable String password;
    private Collection<MemberForGroup> groupsForMember = new HashSet<MemberForGroup>();
    private @Nullable String submitPref;
    private Date created;
    private Date activated;
    private Date lastLogin;
    private Date lastPasswordChange;
    private Integer bounceReceived;
    private @Nullable String externalUserId;
    private Long id;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = Member.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = Member.__dnGetInheritedFieldCount();

    @Override
    public Long getId() {
        return Member.dnGetid(this);
    }

    public static Member create(Database db) throws CreateFailedException {
        return new Member();
    }

    @Override
    public Member insert(Database db) throws InsertFailedException {
        return (Member)super.insert(db);
    }

    public @Nullable String getFirstName() {
        return Member.dnGetfirstName(this);
    }

    public @Nullable String getSurname() {
        return Member.dnGetsurname(this);
    }

    public String getEmail() {
        return Member.dnGetemail(this) == null ? NO_EMAIL : Member.dnGetemail(this);
    }

    public String getUsername() {
        return Member.dnGetusername(this);
    }

    public @Nullable String getPassword() {
        return Member.dnGetpassword(this);
    }

    public @Nullable String getSubmitPref() {
        return Member.dnGetsubmitPref(this);
    }

    public boolean hasSubmitPref(char c) {
        return Member.dnGetsubmitPref(this) != null && Member.dnGetsubmitPref(this).indexOf(c) != -1;
    }

    public Integer getBounceReceived() {
        return Member.dnGetbounceReceived(this);
    }

    public @Nullable String getExternalUserId() {
        return Member.dnGetexternalUserId(this);
    }

    public Date getCreated() {
        return Member.dnGetcreated(this);
    }

    public void setCreated(Date created) {
        Member.dnSetcreated(this, created);
    }

    public Date getActivated() {
        return Member.dnGetactivated(this);
    }

    public void setActivated(Date activated) {
        Member.dnSetactivated(this, activated);
    }

    public Date getLastLogin() {
        return Member.dnGetlastLogin(this);
    }

    public void setLastLogin(Date lastLogin) {
        Member.dnSetlastLogin(this, lastLogin);
    }

    public Date getLastPasswordChange() {
        return Member.dnGetlastPasswordChange(this);
    }

    public void setLastPasswordChange(Date lastPasswordChange) {
        Member.dnSetlastPasswordChange(this, lastPasswordChange);
    }

    public void setBounceReceived(Integer newBounceReceived) {
        Member.dnSetbounceReceived(this, newBounceReceived);
    }

    public void setFirstName(String newFirstName) {
        Member.dnSetfirstName(this, Helper.ensureNotEmpty(newFirstName));
    }

    public void setSurname(String newSurname) {
        Member.dnSetsurname(this, Helper.ensureNotEmpty(newSurname));
    }

    public void setEmail(@Nullable String newEmail) {
        if (newEmail == null || newEmail.isEmpty() || NO_EMAIL.equals(newEmail)) {
            Member.dnSetemail(this, null);
            Member.dnSetemailDomain(this, null);
        } else {
            Member.dnSetemail(this, newEmail);
            int i = Member.dnGetemail(this).indexOf(64);
            if (i == -1) {
                throw new IllegalArgumentException("Email must contain '@'");
            }
            Member.dnSetemailDomain(this, Member.dnGetemail(this).substring(i + 1));
        }
    }

    public void setUsername(String newUsername) {
        Member.dnSetusername(this, Helper.ensureNotEmpty(newUsername));
    }

    public void setPassword(String newPassword) {
        Member.dnSetpassword(this, Helper.ensureNotEmpty(newPassword));
    }

    public void setSubmitPref(String newSubmitPref) {
        Member.dnSetsubmitPref(this, Helper.ensureNotEmpty(newSubmitPref));
    }

    public void setExternalUserId(String newExternalUserId) {
        Member.dnSetexternalUserId(this, Helper.ensureNotEmpty(newExternalUserId));
    }

    public Iterator<MemberForGroup> getGroupsForMember() {
        return this.getGroupsForMemberCol().iterator();
    }

    public Collection<MemberForGroup> getGroupsForMemberCol() {
        return new ArrayList<MemberForGroup>(Member.dnGetgroupsForMember(this));
    }

    public Collection<MemberForGroup> getGroupsForMemberCol(Object predicate) throws QueryFailedException {
        PSQuery pq = new PSQuery(MemberForGroup.class, "this.member.id == memid", predicate);
        pq.addParameter("long memid", this.getId());
        return pq.execute();
    }

    public void addGroupsForMember(MemberForGroup newGroupsForMember) {
        Member.dnGetgroupsForMember(this).add(newGroupsForMember);
    }

    public void removeGroupsForMember(MemberForGroup oldGroupsForMember) {
        Member.dnGetgroupsForMember(this).remove(oldGroupsForMember);
    }

    public String toString() {
        return "member:" + Member.dnGetid(this) + " (" + Member.dnGetusername(this) + ")";
    }

    static {
        EnhancementHelper.registerClass((Class)Member.___dn$loadClass("com.pageseeder.db.model.Member"), (Persistable)new Member());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeObjectField(8, (Object)o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        Member result = new Member();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        Member result = new Member();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.activated = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.bounceReceived = (Integer)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 2: {
                this.created = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.email = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 4: {
                this.emailDomain = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 5: {
                this.externalUserId = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 6: {
                this.firstName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 7: {
                this.groupsForMember = (Collection)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 8: {
                this.id = (Long)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 9: {
                this.lastLogin = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 10: {
                this.lastPasswordChange = (Date)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 11: {
                this.password = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 12: {
                this.submitPref = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 13: {
                this.surname = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 14: {
                this.username = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.activated);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.bounceReceived);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.created);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.email);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.emailDomain);
                break;
            }
            case 5: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.externalUserId);
                break;
            }
            case 6: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.firstName);
                break;
            }
            case 7: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.groupsForMember);
                break;
            }
            case 8: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.id);
                break;
            }
            case 9: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.lastLogin);
                break;
            }
            case 10: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.lastPasswordChange);
                break;
            }
            case 11: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.password);
                break;
            }
            case 12: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.submitPref);
                break;
            }
            case 13: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.surname);
                break;
            }
            case 14: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.username);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(Member obj, int index) {
        switch (index) {
            case 0: {
                this.activated = obj.activated;
                break;
            }
            case 1: {
                this.bounceReceived = obj.bounceReceived;
                break;
            }
            case 2: {
                this.created = obj.created;
                break;
            }
            case 3: {
                this.email = obj.email;
                break;
            }
            case 4: {
                this.emailDomain = obj.emailDomain;
                break;
            }
            case 5: {
                this.externalUserId = obj.externalUserId;
                break;
            }
            case 6: {
                this.firstName = obj.firstName;
                break;
            }
            case 7: {
                this.groupsForMember = obj.groupsForMember;
                break;
            }
            case 8: {
                this.id = obj.id;
                break;
            }
            case 9: {
                this.lastLogin = obj.lastLogin;
                break;
            }
            case 10: {
                this.lastPasswordChange = obj.lastPasswordChange;
                break;
            }
            case 11: {
                this.password = obj.password;
                break;
            }
            case 12: {
                this.submitPref = obj.submitPref;
                break;
            }
            case 13: {
                this.surname = obj.surname;
                break;
            }
            case 14: {
                this.username = obj.username;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Member)) {
            throw new IllegalArgumentException("object is not an object of type com.pageseeder.db.model.Member");
        }
        Member other = (Member)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"activated", "bounceReceived", "created", "email", "emailDomain", "externalUserId", "firstName", "groupsForMember", "id", "lastLogin", "lastPasswordChange", "password", "submitPref", "surname", "username"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 15;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static Date dnGetactivated(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 0, (Object)objPC.activated);
        }
        return objPC.activated;
    }

    private static void dnSetactivated(Member objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0, (Object)objPC.activated, (Object)val);
        } else {
            objPC.activated = val;
        }
    }

    private static Integer dnGetbounceReceived(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return (Integer)objPC.dnStateManager.getObjectField((Persistable)objPC, 1, (Object)objPC.bounceReceived);
        }
        return objPC.bounceReceived;
    }

    private static void dnSetbounceReceived(Member objPC, Integer val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1, (Object)objPC.bounceReceived, (Object)val);
        } else {
            objPC.bounceReceived = val;
        }
    }

    private static Date dnGetcreated(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, (Object)objPC.created);
        }
        return objPC.created;
    }

    private static void dnSetcreated(Member objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, (Object)objPC.created, (Object)val);
        } else {
            objPC.created = val;
        }
    }

    private static String dnGetemail(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3, objPC.email);
        }
        return objPC.email;
    }

    private static void dnSetemail(Member objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3, objPC.email, val);
        } else {
            objPC.email = val;
        }
    }

    private static String dnGetemailDomain(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4, objPC.emailDomain);
        }
        return objPC.emailDomain;
    }

    private static void dnSetemailDomain(Member objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4, objPC.emailDomain, val);
        } else {
            objPC.emailDomain = val;
        }
    }

    private static String dnGetexternalUserId(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 5, objPC.externalUserId);
        }
        return objPC.externalUserId;
    }

    private static void dnSetexternalUserId(Member objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 5, objPC.externalUserId, val);
        } else {
            objPC.externalUserId = val;
        }
    }

    private static String dnGetfirstName(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 6, objPC.firstName);
        }
        return objPC.firstName;
    }

    private static void dnSetfirstName(Member objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 6, objPC.firstName, val);
        } else {
            objPC.firstName = val;
        }
    }

    private static Collection dnGetgroupsForMember(Member objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 7)) {
            return (Collection)objPC.dnStateManager.getObjectField((Persistable)objPC, 7, objPC.groupsForMember);
        }
        return objPC.groupsForMember;
    }

    private static void dnSetgroupsForMember(Member objPC, Collection val) {
        if (objPC.dnStateManager == null) {
            objPC.groupsForMember = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 7, objPC.groupsForMember, (Object)val);
        }
    }

    private static Long dnGetid(Member objPC) {
        return objPC.id;
    }

    private static void dnSetid(Member objPC, Long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 8, (Object)objPC.id, (Object)val);
        }
    }

    private static Date dnGetlastLogin(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 9)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 9, (Object)objPC.lastLogin);
        }
        return objPC.lastLogin;
    }

    private static void dnSetlastLogin(Member objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 9, (Object)objPC.lastLogin, (Object)val);
        } else {
            objPC.lastLogin = val;
        }
    }

    private static Date dnGetlastPasswordChange(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 10)) {
            return (Date)objPC.dnStateManager.getObjectField((Persistable)objPC, 10, (Object)objPC.lastPasswordChange);
        }
        return objPC.lastPasswordChange;
    }

    private static void dnSetlastPasswordChange(Member objPC, Date val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 10, (Object)objPC.lastPasswordChange, (Object)val);
        } else {
            objPC.lastPasswordChange = val;
        }
    }

    private static String dnGetpassword(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 11)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 11, objPC.password);
        }
        return objPC.password;
    }

    private static void dnSetpassword(Member objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 11, objPC.password, val);
        } else {
            objPC.password = val;
        }
    }

    private static String dnGetsubmitPref(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 12)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 12, objPC.submitPref);
        }
        return objPC.submitPref;
    }

    private static void dnSetsubmitPref(Member objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 12, objPC.submitPref, val);
        } else {
            objPC.submitPref = val;
        }
    }

    private static String dnGetsurname(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 13)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 13, objPC.surname);
        }
        return objPC.surname;
    }

    private static void dnSetsurname(Member objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 13, objPC.surname, val);
        } else {
            objPC.surname = val;
        }
    }

    private static String dnGetusername(Member objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 14)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 14, objPC.username);
        }
        return objPC.username;
    }

    private static void dnSetusername(Member objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 14, objPC.username, val);
        } else {
            objPC.username = val;
        }
    }
}

