/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.model;

import com.pageseeder.db.CreateFailedException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.InsertFailedException;
import com.pageseeder.db.PSQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.Helper;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.jdo.JDOFatalInternalException;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;
import org.eclipse.jdt.annotation.Nullable;

public final class Locator
extends DBObject
implements Persistable {
    private static final String DEFAULT = "default";
    private @Nullable String fragment;
    private URI uri;
    private Collection<LocatorForXLink> xlinksForLocator = new HashSet<LocatorForXLink>();
    private Collection<XLink> publications = new HashSet<XLink>();
    private Boolean accepted = Boolean.TRUE;
    private @Nullable String behavior;
    private Long id;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = Locator.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = Locator.__dnGetInheritedFieldCount();

    @Override
    public Long getId() {
        return Locator.dnGetid(this);
    }

    public static Locator create(Database db) throws CreateFailedException {
        return new Locator();
    }

    @Override
    public Locator insert(Database db) throws InsertFailedException {
        return (Locator)super.insert(db);
    }

    public @Nullable String getFragment() {
        if (DEFAULT.equalsIgnoreCase(Locator.dnGetfragment(this))) {
            return DEFAULT;
        }
        return Locator.dnGetfragment(this);
    }

    public Boolean getAccepted() {
        return Locator.dnGetaccepted(this);
    }

    public String getBehavior() {
        return Locator.dnGetbehavior(this);
    }

    public void setAccepted(Boolean newAccepted) {
        Locator.dnSetaccepted(this, newAccepted);
    }

    public void setFragment(String newFragment) {
        if (DEFAULT.equalsIgnoreCase(newFragment)) {
            Locator.dnSetfragment(this, DEFAULT);
        } else {
            Locator.dnSetfragment(this, Helper.ensureNotEmpty(newFragment));
        }
    }

    public void setBehavior(String newBehavior) {
        Locator.dnSetbehavior(this, Helper.ensureNotEmpty(newBehavior));
    }

    public Iterator<LocatorForXLink> getXLinksForLocator() {
        return this.getXLinksForLocatorCol().iterator();
    }

    public Iterator<LocatorForXLink> getXLinksForLocator(Object predicate) {
        return this.getXLinksForLocatorCol(predicate).iterator();
    }

    public Collection<LocatorForXLink> getXLinksForLocatorCol() {
        return new ArrayList<LocatorForXLink>(Locator.dnGetxlinksForLocator(this));
    }

    public Collection<LocatorForXLink> getXLinksForLocatorCol(Object predicate) {
        try {
            PSQuery pq = new PSQuery(LocatorForXLink.class, "this.locator.id == lid", predicate);
            pq.addParameter("long lid", this.getId());
            return pq.execute();
        }
        catch (QueryFailedException e) {
            DatabaseQuery.logDatabaseException(e);
            return Collections.emptyList();
        }
    }

    public Collection<XLink> getPublications() {
        return new ArrayList<XLink>(Locator.dnGetpublications(this));
    }

    public void addXLinksForLocator(LocatorForXLink newXLinksForLocator) {
        Locator.dnGetxlinksForLocator(this).add(newXLinksForLocator);
        newXLinksForLocator.setLocator(this);
    }

    public boolean addPublications(XLink newXLink) {
        return Locator.dnGetpublications(this).add(newXLink);
    }

    public void removeXLinksForLocator(LocatorForXLink oldXLinksForLocator) {
        Locator.dnGetxlinksForLocator(this).remove(oldXLinksForLocator);
    }

    public void removePublications(XLink oldXLink) {
        Locator.dnGetpublications(this).remove(oldXLink);
    }

    public URI getURI() {
        return Locator.dnGeturi(this);
    }

    public void setURI(URI uri) {
        Locator.dnSeturi(this, uri);
    }

    public String toString() {
        return "locator:" + Locator.dnGetid(this) + " (" + Locator.dnGetfragment(this) + ")";
    }

    static {
        EnhancementHelper.registerClass((Class)Locator.___dn$loadClass("com.pageseeder.db.model.Locator"), (Persistable)new Locator());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeObjectField(3, (Object)o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        Locator result = new Locator();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        Locator result = new Locator();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.accepted = (Boolean)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 1: {
                this.behavior = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 2: {
                this.fragment = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.id = (Long)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.publications = (Collection)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 5: {
                this.uri = (URI)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 6: {
                this.xlinksForLocator = (Collection)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.accepted);
                break;
            }
            case 1: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.behavior);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.fragment);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.id);
                break;
            }
            case 4: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.publications);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.uri);
                break;
            }
            case 6: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.xlinksForLocator);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(Locator obj, int index) {
        switch (index) {
            case 0: {
                this.accepted = obj.accepted;
                break;
            }
            case 1: {
                this.behavior = obj.behavior;
                break;
            }
            case 2: {
                this.fragment = obj.fragment;
                break;
            }
            case 3: {
                this.id = obj.id;
                break;
            }
            case 4: {
                this.publications = obj.publications;
                break;
            }
            case 5: {
                this.uri = obj.uri;
                break;
            }
            case 6: {
                this.xlinksForLocator = obj.xlinksForLocator;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Locator)) {
            throw new IllegalArgumentException("object is not an object of type com.pageseeder.db.model.Locator");
        }
        Locator other = (Locator)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"accepted", "behavior", "fragment", "id", "publications", "uri", "xlinksForLocator"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 7;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static Boolean dnGetaccepted(Locator objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return (Boolean)objPC.dnStateManager.getObjectField((Persistable)objPC, 0, (Object)objPC.accepted);
        }
        return objPC.accepted;
    }

    private static void dnSetaccepted(Locator objPC, Boolean val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 0, (Object)objPC.accepted, (Object)val);
        } else {
            objPC.accepted = val;
        }
    }

    private static String dnGetbehavior(Locator objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 1, objPC.behavior);
        }
        return objPC.behavior;
    }

    private static void dnSetbehavior(Locator objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 1, objPC.behavior, val);
        } else {
            objPC.behavior = val;
        }
    }

    private static String dnGetfragment(Locator objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2, objPC.fragment);
        }
        return objPC.fragment;
    }

    private static void dnSetfragment(Locator objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2, objPC.fragment, val);
        } else {
            objPC.fragment = val;
        }
    }

    private static Long dnGetid(Locator objPC) {
        return objPC.id;
    }

    private static void dnSetid(Locator objPC, Long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3, (Object)objPC.id, (Object)val);
        }
    }

    private static Collection dnGetpublications(Locator objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return (Collection)objPC.dnStateManager.getObjectField((Persistable)objPC, 4, objPC.publications);
        }
        return objPC.publications;
    }

    private static void dnSetpublications(Locator objPC, Collection val) {
        if (objPC.dnStateManager == null) {
            objPC.publications = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 4, objPC.publications, (Object)val);
        }
    }

    private static URI dnGeturi(Locator objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return (URI)objPC.dnStateManager.getObjectField((Persistable)objPC, 5, (Object)objPC.uri);
        }
        return objPC.uri;
    }

    private static void dnSeturi(Locator objPC, URI val) {
        if (objPC.dnStateManager == null) {
            objPC.uri = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5, (Object)objPC.uri, (Object)val);
        }
    }

    private static Collection dnGetxlinksForLocator(Locator objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return (Collection)objPC.dnStateManager.getObjectField((Persistable)objPC, 6, objPC.xlinksForLocator);
        }
        return objPC.xlinksForLocator;
    }

    private static void dnSetxlinksForLocator(Locator objPC, Collection val) {
        if (objPC.dnStateManager == null) {
            objPC.xlinksForLocator = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 6, objPC.xlinksForLocator, (Object)val);
        }
    }
}

