/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.db.model;

import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.CreateFailedException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.InsertFailedException;
import com.pageseeder.db.PSQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.GroupForGroup;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.GroupURIForGroup;
import com.pageseeder.db.model.Helper;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.MemberForGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.jdo.JDOFatalInternalException;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;
import org.datanucleus.identity.LongId;
import org.eclipse.jdt.annotation.Nullable;

public final class Group
extends DBObject
implements Persistable {
    private String name;
    private String description;
    private @Nullable String title;
    private Collection<GroupURIForGroup> groupURIs = new HashSet<GroupURIForGroup>();
    private Collection<GroupForGroup> memberGroups;
    private @Nullable Locator defaultLocator;
    private @Nullable String controlGroupName;
    private @Nullable String detailsForm;
    private @Nullable String owner;
    private @Nullable String message;
    private @Nullable String flags;
    private @Nullable String ownerDirectory;
    private @Nullable String homeURL;
    private Long id;
    private @Nullable Integer indexVersion = Settings.CURRENT_INDEX_VERSION;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    private static final String[] dnFieldNames = Group.__dnFieldNamesInit();
    private static final int dnInheritedFieldCount = Group.__dnGetInheritedFieldCount();

    @Override
    public Long getId() {
        return Group.dnGetid(this);
    }

    public static Group create(Database db) throws CreateFailedException {
        return new Group();
    }

    @Override
    public Group insert(Database db) throws InsertFailedException {
        return (Group)super.insert(db);
    }

    public Integer getIndexVersion() {
        return Group.dnGetindexVersion(this) == null ? 3300 : Group.dnGetindexVersion(this);
    }

    public @Nullable String getTitle() {
        return Group.dnGettitle(this);
    }

    public String getName() {
        return Group.dnGetname(this);
    }

    public String getDescription() {
        return Group.dnGetdescription(this);
    }

    public @Nullable String getControlGroupName() {
        return Group.dnGetcontrolGroupName(this);
    }

    public @Nullable String getDetailsForm() {
        return Group.dnGetdetailsForm(this);
    }

    public @Nullable String getOwner() {
        return Group.dnGetowner(this);
    }

    public @Nullable String getMessage() {
        return Group.dnGetmessage(this);
    }

    public @Nullable String getFlags() {
        return Group.dnGetflags(this);
    }

    public boolean hasFlag(char c) {
        return Group.dnGetflags(this) != null && Group.dnGetflags(this).indexOf(c) != -1;
    }

    public @Nullable String getOwnerDirectory() {
        return Group.dnGetownerDirectory(this);
    }

    public @Nullable String getHomeURL() {
        return Group.dnGethomeURL(this);
    }

    public void setIndexVersion(Integer version) {
        Group.dnSetindexVersion(this, version);
    }

    public void setTitle(@Nullable String newTitle) {
        Group.dnSettitle(this, Helper.ensureNotEmpty(newTitle));
    }

    public void setName(String newName) {
        if (newName.isEmpty()) {
            throw new IllegalArgumentException("Group name cannot be empty");
        }
        Group.dnSetname(this, newName);
    }

    public void setDescription(String newDescription) {
        if (newDescription.isEmpty()) {
            throw new IllegalArgumentException("Group description cannot be empty");
        }
        Group.dnSetdescription(this, newDescription);
    }

    public void setControlGroupName(@Nullable String newControlGroupName) {
        Group.dnSetcontrolGroupName(this, Helper.ensureNotEmpty(newControlGroupName));
    }

    public void setDetailsForm(@Nullable String newDetailsForm) {
        Group.dnSetdetailsForm(this, Helper.ensureNotEmpty(newDetailsForm));
    }

    public void setOwner(@Nullable String newOwner) {
        Group.dnSetowner(this, Helper.ensureNotEmpty(newOwner));
    }

    public void setMessage(@Nullable String newMessage) {
        Group.dnSetmessage(this, Helper.ensureNotEmpty(newMessage));
    }

    public void setFlags(@Nullable String newFlags) {
        Group.dnSetflags(this, Helper.ensureNotEmpty(newFlags));
    }

    public void setOwnerDirectory(@Nullable String newOwnerDirectory) {
        Group.dnSetownerDirectory(this, Helper.ensureNotEmpty(newOwnerDirectory));
    }

    public void setHomeURL(@Nullable String newHomeURL) {
        Group.dnSethomeURL(this, Helper.ensureNotEmpty(newHomeURL));
    }

    public @Nullable Locator getDefaultLocator() {
        return Group.dnGetdefaultLocator(this);
    }

    public void setDefaultLocator(@Nullable Locator newDefaultLocator) {
        Group.dnSetdefaultLocator(this, newDefaultLocator);
    }

    public Collection<GroupForGroup> getMemberGroups() {
        return new ArrayList<GroupForGroup>(Group.dnGetmemberGroups(this));
    }

    public void addGroupForGroup(GroupForGroup subgroup) {
        if (!Group.dnGetmemberGroups(this).contains(subgroup)) {
            Group.dnGetmemberGroups(this).add(subgroup);
        }
    }

    public void removeGroupForGroup(GroupForGroup subgroup) {
        Group.dnGetmemberGroups(this).remove(subgroup);
    }

    public Collection<MemberForGroup> getMembersForGroupCol(Object predicate) {
        try {
            PSQuery pq = new PSQuery(MemberForGroup.class, "this.group.id == gid", predicate);
            pq.addParameter("long gid", this.getId());
            return pq.execute();
        }
        catch (QueryFailedException ex) {
            DatabaseQuery.logDatabaseException(ex);
            return Collections.emptyList();
        }
    }

    public void addMembersForGroup(MemberForGroup newMembersForGroup) {
        newMembersForGroup.setGroup(this);
    }

    public Iterator<GroupURI> getGroupURIs() {
        return this.getGroupURIsCol().iterator();
    }

    public Iterator<GroupURIForGroup> getGroupURIForGroups() {
        return this.getGroupURIForGroupsCol().iterator();
    }

    public Collection<GroupURIForGroup> getGroupURIForGroupsCol() {
        return new ArrayList<GroupURIForGroup>(Group.dnGetgroupURIs(this));
    }

    public Collection<GroupURI> getGroupURIsCol() {
        ArrayList<GroupURI> guris = new ArrayList<GroupURI>();
        for (GroupURIForGroup gufg : Group.dnGetgroupURIs(this)) {
            guris.add(gufg.getGroupURI());
        }
        return guris;
    }

    public void addGroupURIs(GroupURIForGroup newGroupURI) {
        Group.dnGetgroupURIs(this).add(newGroupURI);
    }

    public void removeGroupURIs(GroupURIForGroup oldGroupURI) {
        Group.dnGetgroupURIs(this).remove(oldGroupURI);
    }

    public void removeGroupURIs(@Nullable GroupURI oldGroupURI) {
        if (oldGroupURI == null) {
            return;
        }
        GroupURIForGroup theone = null;
        for (GroupURIForGroup gfg : Group.dnGetgroupURIs(this)) {
            if (!gfg.getGroupURI().equals(oldGroupURI)) continue;
            theone = gfg;
            break;
        }
        if (theone != null) {
            Group.dnGetgroupURIs(this).remove(theone);
        }
    }

    public String toString() {
        return "group:" + Group.dnGetid(this) + " (" + Group.dnGetname(this) + ")";
    }

    static {
        EnhancementHelper.registerClass((Class)Group.___dn$loadClass("com.pageseeder.db.model.Group"), (Persistable)new Group());
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("oid is not instanceof org.datanucleus.identity.LongId");
        }
        LongId o = (LongId)oid;
        fc.storeObjectField(7, (Object)o.getKey());
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof LongId)) {
            throw new ClassCastException("key class is not org.datanucleus.identity.LongId or null");
        }
        LongId o = (LongId)oid;
        this.id = o.getKey();
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object paramObject) {
        throw new JDOFatalInternalException("It's illegal to call dnCopyKeyFieldsToObjectId for a class with single-field identity.");
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        return null;
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        return null;
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContextReference() : null;
    }

    public final StateManager dnGetStateManager() {
        return this.dnStateManager;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        return false;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
    }

    public Object dnNewObjectIdInstance() {
        return new LongId(this.getClass(), this.id);
    }

    public Object dnNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new LongId(this.getClass(), (Long)key);
        }
        return new LongId(this.getClass(), (String)key);
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public boolean dnIsDetached() {
        return false;
    }

    public Persistable dnNewInstance(StateManager sm) {
        Group result = new Group();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        Group result = new Group();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.controlGroupName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 1: {
                this.defaultLocator = (Locator)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 2: {
                this.description = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 3: {
                this.detailsForm = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 4: {
                this.flags = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 5: {
                this.groupURIs = (Collection)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 6: {
                this.homeURL = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 7: {
                this.id = (Long)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 8: {
                this.indexVersion = (Integer)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 9: {
                this.memberGroups = (Collection)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 10: {
                this.message = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 11: {
                this.name = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 12: {
                this.owner = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 13: {
                this.ownerDirectory = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            case 14: {
                this.title = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.controlGroupName);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.defaultLocator);
                break;
            }
            case 2: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.description);
                break;
            }
            case 3: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.detailsForm);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.flags);
                break;
            }
            case 5: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.groupURIs);
                break;
            }
            case 6: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.homeURL);
                break;
            }
            case 7: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.id);
                break;
            }
            case 8: {
                this.dnStateManager.providedObjectField((Persistable)this, index, (Object)this.indexVersion);
                break;
            }
            case 9: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.memberGroups);
                break;
            }
            case 10: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.message);
                break;
            }
            case 11: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.name);
                break;
            }
            case 12: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.owner);
                break;
            }
            case 13: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.ownerDirectory);
                break;
            }
            case 14: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.title);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(Group obj, int index) {
        switch (index) {
            case 0: {
                this.controlGroupName = obj.controlGroupName;
                break;
            }
            case 1: {
                this.defaultLocator = obj.defaultLocator;
                break;
            }
            case 2: {
                this.description = obj.description;
                break;
            }
            case 3: {
                this.detailsForm = obj.detailsForm;
                break;
            }
            case 4: {
                this.flags = obj.flags;
                break;
            }
            case 5: {
                this.groupURIs = obj.groupURIs;
                break;
            }
            case 6: {
                this.homeURL = obj.homeURL;
                break;
            }
            case 7: {
                this.id = obj.id;
                break;
            }
            case 8: {
                this.indexVersion = obj.indexVersion;
                break;
            }
            case 9: {
                this.memberGroups = obj.memberGroups;
                break;
            }
            case 10: {
                this.message = obj.message;
                break;
            }
            case 11: {
                this.name = obj.name;
                break;
            }
            case 12: {
                this.owner = obj.owner;
                break;
            }
            case 13: {
                this.ownerDirectory = obj.ownerDirectory;
                break;
            }
            case 14: {
                this.title = obj.title;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Group)) {
            throw new IllegalArgumentException("object is not an object of type com.pageseeder.db.model.Group");
        }
        Group other = (Group)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"controlGroupName", "defaultLocator", "description", "detailsForm", "flags", "groupURIs", "homeURL", "id", "indexVersion", "memberGroups", "message", "name", "owner", "ownerDirectory", "title"};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 15;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private static String dnGetcontrolGroupName(Group objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 0, objPC.controlGroupName);
        }
        return objPC.controlGroupName;
    }

    private static void dnSetcontrolGroupName(Group objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 0, objPC.controlGroupName, val);
        } else {
            objPC.controlGroupName = val;
        }
    }

    private static Locator dnGetdefaultLocator(Group objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return (Locator)objPC.dnStateManager.getObjectField((Persistable)objPC, 1, (Object)objPC.defaultLocator);
        }
        return objPC.defaultLocator;
    }

    private static void dnSetdefaultLocator(Group objPC, Locator val) {
        if (objPC.dnStateManager == null) {
            objPC.defaultLocator = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1, (Object)objPC.defaultLocator, (Object)val);
        }
    }

    private static String dnGetdescription(Group objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 2, objPC.description);
        }
        return objPC.description;
    }

    private static void dnSetdescription(Group objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 2, objPC.description, val);
        } else {
            objPC.description = val;
        }
    }

    private static String dnGetdetailsForm(Group objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 3, objPC.detailsForm);
        }
        return objPC.detailsForm;
    }

    private static void dnSetdetailsForm(Group objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 3, objPC.detailsForm, val);
        } else {
            objPC.detailsForm = val;
        }
    }

    private static String dnGetflags(Group objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4, objPC.flags);
        }
        return objPC.flags;
    }

    private static void dnSetflags(Group objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4, objPC.flags, val);
        } else {
            objPC.flags = val;
        }
    }

    private static Collection dnGetgroupURIs(Group objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 5)) {
            return (Collection)objPC.dnStateManager.getObjectField((Persistable)objPC, 5, objPC.groupURIs);
        }
        return objPC.groupURIs;
    }

    private static void dnSetgroupURIs(Group objPC, Collection val) {
        if (objPC.dnStateManager == null) {
            objPC.groupURIs = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 5, objPC.groupURIs, (Object)val);
        }
    }

    private static String dnGethomeURL(Group objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 6)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 6, objPC.homeURL);
        }
        return objPC.homeURL;
    }

    private static void dnSethomeURL(Group objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 6, objPC.homeURL, val);
        } else {
            objPC.homeURL = val;
        }
    }

    private static Long dnGetid(Group objPC) {
        return objPC.id;
    }

    private static void dnSetid(Group objPC, Long val) {
        if (objPC.dnStateManager == null) {
            objPC.id = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 7, (Object)objPC.id, (Object)val);
        }
    }

    private static Integer dnGetindexVersion(Group objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 8)) {
            return (Integer)objPC.dnStateManager.getObjectField((Persistable)objPC, 8, (Object)objPC.indexVersion);
        }
        return objPC.indexVersion;
    }

    private static void dnSetindexVersion(Group objPC, Integer val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 8, (Object)objPC.indexVersion, (Object)val);
        } else {
            objPC.indexVersion = val;
        }
    }

    private static Collection dnGetmemberGroups(Group objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 9)) {
            return (Collection)objPC.dnStateManager.getObjectField((Persistable)objPC, 9, objPC.memberGroups);
        }
        return objPC.memberGroups;
    }

    private static void dnSetmemberGroups(Group objPC, Collection val) {
        if (objPC.dnStateManager == null) {
            objPC.memberGroups = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 9, objPC.memberGroups, (Object)val);
        }
    }

    private static String dnGetmessage(Group objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 10)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 10, objPC.message);
        }
        return objPC.message;
    }

    private static void dnSetmessage(Group objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 10, objPC.message, val);
        } else {
            objPC.message = val;
        }
    }

    private static String dnGetname(Group objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 11)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 11, objPC.name);
        }
        return objPC.name;
    }

    private static void dnSetname(Group objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 11, objPC.name, val);
        } else {
            objPC.name = val;
        }
    }

    private static String dnGetowner(Group objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 12)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 12, objPC.owner);
        }
        return objPC.owner;
    }

    private static void dnSetowner(Group objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 12, objPC.owner, val);
        } else {
            objPC.owner = val;
        }
    }

    private static String dnGetownerDirectory(Group objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 13)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 13, objPC.ownerDirectory);
        }
        return objPC.ownerDirectory;
    }

    private static void dnSetownerDirectory(Group objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 13, objPC.ownerDirectory, val);
        } else {
            objPC.ownerDirectory = val;
        }
    }

    private static String dnGettitle(Group objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 14)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 14, objPC.title);
        }
        return objPC.title;
    }

    private static void dnSettitle(Group objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 14, objPC.title, val);
        } else {
            objPC.title = val;
        }
    }
}

