/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.epub.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public final class ExportTask
extends Task {
    private File _source;
    private File _destination;
    private File _working;
    private File _config;

    public void setSrc(File source) {
        if (!source.exists()) {
            throw new BuildException("the document " + source.getName() + " doesn't exist");
        }
        if (source.isDirectory()) {
            throw new BuildException("the document " + source.getName() + " can't be a directory");
        }
        this._source = source;
    }

    public void setDest(File destination) {
        if (destination.exists() && destination.isDirectory()) {
            throw new BuildException("if document epub exists, it must be a file");
        }
        this._destination = destination;
    }

    public void setWorking(File working) {
        if (working.exists() && !working.isDirectory()) {
            throw new BuildException("if working folder exists, it must be a directory");
        }
        this._working = working;
    }

    public void setConfig(File config) {
        if (!config.exists() || config.isDirectory()) {
            throw new BuildException("your configuration file must exist and be a file");
        }
        this._config = config;
    }

    public void execute() throws BuildException {
        String name;
        if (this._source == null) {
            throw new BuildException("Source presentation must be specified using 'src' attribute");
        }
        if (this._working == null) {
            String tmp = "antepub-" + System.currentTimeMillis();
            this._working = new File(System.getProperty("java.io.tmpdir"), tmp);
        }
        if (!this._working.exists()) {
            this._working.mkdirs();
        }
        if ((name = this._source.getName()).endsWith(".xml")) {
            name = name.substring(0, name.length() - 4);
        }
        if (this._destination == null) {
            this._destination = new File(this._source.getParentFile(), ".pptx");
            this.log("Destination set to " + this._destination.getName());
        }
        if (this._config == null) {
            this._config = null;
            this.log("Using default epub configuration for import");
        }
        File prepacked = new File(this._working, "prepacked");
        this.log("=============================================================================");
        this.log("SORRY, but this has yet to be implemented!!!");
        this.log("=============================================================================");
    }
}

