/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.oauth.authorizer;

import com.pageseeder.base.oauth.core.OAuthParameter;
import com.pageseeder.base.oauth.core.OAuthResponse;
import java.util.concurrent.TimeUnit;

public final class TokenResponse
extends OAuthResponse {
    public TokenResponse(int status) {
        super(status);
    }

    public TokenResponse setState(String state) {
        this.parameters.put(OAuthParameter.state, state);
        return this;
    }

    public TokenResponse setAccessToken(String token) {
        this.parameters.put(OAuthParameter.access_token, token);
        return this;
    }

    public TokenResponse setExpiresIn(long duration, TimeUnit unit) {
        String expiresIn = Long.toString(TimeUnit.SECONDS.convert(duration, unit));
        this.parameters.put(OAuthParameter.expires_in, expiresIn);
        return this;
    }

    public TokenResponse setRefreshToken(String refreshToken) {
        this.parameters.put(OAuthParameter.refresh_token, refreshToken);
        return this;
    }

    public TokenResponse setTokenType(String tokenType) {
        this.parameters.put(OAuthParameter.token_type, tokenType);
        return this;
    }

    public TokenResponse setIDToken(String token) {
        this.parameters.put(OAuthParameter.id_token, token);
        return this;
    }

    public TokenResponse location(String location) {
        this.location = location;
        return this;
    }
}

