/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.ixml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.sax.SAXResult;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.ixml.FlintEntityResolver;
import org.pageseeder.flint.ixml.FlintErrorHandler;
import org.pageseeder.flint.ixml.IndexDocumentHandler;
import org.pageseeder.flint.ixml.IndexDocumentHandler_2_0;
import org.pageseeder.flint.ixml.IndexDocumentHandler_5_0;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class IndexParser {
    private final XMLReader _reader;
    private final SAXResult _result;
    private final IndexDocumentHandler _handler;

    IndexParser(XMLReader reader) {
        this._reader = reader;
        this._reader.setEntityResolver(FlintEntityResolver.getInstance());
        this._reader.setErrorHandler(new FlintErrorHandler());
        this._result = null;
        this._handler = null;
    }

    IndexParser(String catalog) {
        this._reader = null;
        this._handler = new AutoHandler(catalog);
        this._result = new SAXResult(this._handler);
    }

    public SAXResult getResult() {
        return this._result;
    }

    public List<FlintDocument> getDocuments() {
        return this._handler == null ? null : this._handler.getDocuments();
    }

    public synchronized List<FlintDocument> process(InputSource source, String catalog) throws IndexException {
        try {
            AutoHandler handler = new AutoHandler(catalog);
            this._reader.setContentHandler(handler);
            this._reader.parse(source);
            return handler.getDocuments();
        }
        catch (SAXException ex) {
            throw new IndexException("An SAX error occurred while parsing source " + source.getSystemId() + ": " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new IndexException("An I/O error occurred while parsing the file " + source.getSystemId() + ": " + ex.getMessage(), ex);
        }
    }

    public synchronized List<FlintDocument> process(File f, String catalog) throws IndexException {
        try {
            InputSource source = new InputSource(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));
            source.setSystemId(f.toURI().toURL().toExternalForm());
            return this.process(source, catalog);
        }
        catch (IOException ex) {
            throw new IndexException("I/O error occurred while generating file input source: " + ex.getMessage(), ex);
        }
    }

    private static final class AutoHandler
    extends DefaultHandler
    implements IndexDocumentHandler {
        private final String _catalog;
        private IndexDocumentHandler _handler;

        public AutoHandler(String catalog) {
            this._catalog = catalog;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("documents".equals(qName) || "documents".equals(localName)) {
                String version = atts.getValue("version");
                if ("5.0".equals(version)) {
                    this._handler = new IndexDocumentHandler_5_0(this._catalog);
                } else if ("2.0".equals(version)) {
                    this._handler = new IndexDocumentHandler_2_0();
                } else {
                    throw new SAXException("Unsupported iXML version " + version + ", only 2.0 and 5.0 are supported");
                }
                this._handler.startDocument();
            }
            if (this._handler != null) {
                this._handler.startElement(uri, localName, qName, atts);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this._handler != null) {
                this._handler.endElement(uri, localName, qName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this._handler != null) {
                this._handler.characters(ch, start, length);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this._handler != null) {
                this._handler.endDocument();
            }
        }

        @Override
        public List<FlintDocument> getDocuments() {
            if (this._handler == null) {
                return Collections.emptyList();
            }
            return this._handler.getDocuments();
        }
    }
}

