/**
 * $Id: DefinedValueURIHandler.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.valueuri.condition;

import  com.idaremedia.antx.apis.Requester;
import  com.idaremedia.antx.condition.IsNotWhitespace;
import  com.idaremedia.antx.parameters.Handling;
import  com.idaremedia.antx.starters.ValueURIHandlerSkeleton;

/**
 * Value URI handler that returns the true if the source value is not whitespace and
 * does not contain unresolved property references. Useful for checking incoming
 * attributes to macrodefs and criteria.
 * <p/>
 * <b>Example Usage:</b><pre>
 *   &lt;do true="${<b>$isdefined:</b>@{arg1}}"&gt;
 *      &#8230;
 *
 *   &lt;domatch value="${<b>$defined:</b>@{attribute}}"&gt;
 *      &lt;true&gt;&#8230;
 *      &lt;otherwise&gt;&#8230;
 *
 *   -- To Install --
 *    &lt;manageuris action="install"&gt;
 *       &lt;parameter name="defined"
 *           value="com.idaremedia.antx.valueuri.condition.DefinedValueURIHandler"/&gt;
 *       &lt;parameter name="isdefined"
 *           value="com.idaremedia.antx.valueuri.condition.DefinedValueURIHandler"/&gt;
 *    &lt;/manageuris&gt;
 * </pre>
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   multiple
 * @.group    api,helper
 **/

public final class DefinedValueURIHandler extends ValueURIHandlerSkeleton
{
    /**
     * Initializes a new $defined: value uri handler.
     **/
    public DefinedValueURIHandler()
    {
        super();
    }


    /**
     * Returns <span class="src">true</span> iff the incoming fragment
     * is not all whitespace and contains no unresolved property references.
     **/
    public String valueFrom(String uriFragment, String fullUri, Requester clnt)
    {
        IsNotWhitespace check = new IsNotWhitespace();
        check.setProject(clnt.getProject());
        check.xsetFromURI(uriFragment);
        check.setMalformed(Handling.REJECT);
        return String.valueOf(check.eval());
    }
}

/* end-of-DefinedValueURIHandler.java */