/**
 * $Id: UncloneableNothingType.java 187 2007-03-25 17:59:16Z ssmc $
 * Copyright 2007 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; version 2.1 of the License.
 *
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://antxtras.sf.net/          EMAIL- jware[at]users[dot]sourceforge[dot]net
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  java.util.Iterator;
import  java.util.Map;
 
import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.helpers.Strings;
import  com.idaremedia.antx.ownhelpers.ProjectDependentSkeleton;

/**
 * Helper that does not come from Ant's data type (which implements Cloneable as of
 * Ant 1&#46;7).
 *
 * @since     JWare/AntXtras 0.5.1
 * @author    ssmc, &copy;2007 <a href="http://antxtras.sf.net/">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5.1
 * @.safety   single
 * @.group    impl,test,helper
 **/

public final class UncloneableNothingType extends ProjectDependentSkeleton
{
    /**
     * Initializes a new uncloneable nothing type instance.
     **/
    public UncloneableNothingType()
    {
    }


    /**
     * Tries to return an interesting identifier for this type.
     **/
    public String getId()
    {
        return getClass().getName()+"@"+
            String.valueOf(System.identityHashCode(this));
    }



    /**
     * Tries to determine the (fully qualified) script name of
     * this object. Will return "<span class="src">none</span>" if
     * not able to determine proper name.
     * @since JWare/AntX 0.4
     * @.bug Does not work for two declarations of same type in
     *       different namespaces!
     **/
    public synchronized String getTypeName()
    {
        if (m_typeName==null) {
            verifyInProject_("typeName");
            Class myClass = getClass();
            Iterator itr= getProject().getDataTypeDefinitions().
                entrySet().iterator();//lock|clone?
            while (itr.hasNext()) {
                Map.Entry mE= (Map.Entry)itr.next();
                if (myClass==mE.getValue()) {
                    m_typeName = (String)mE.getKey();
                    break;
                }
            }
        }
        return m_typeName==null ? Strings.NONE : m_typeName;
    }



    /** Sets this type's trigger attribute; some diagnostics
        are logged for manual eyeballing. **/
    public void setLabel(String label)
    {
        m_label = label;
        StringBuffer sb = new StringBuffer(100);
        sb.append(label);
        sb.append(Strings.NL);
        sb.append("Id: ");
        sb.append(getId());
        sb.append(Strings.NL);
        sb.append("TypeName: ");
        sb.append(getTypeName());
        System.out.println(sb.toString());
    }
    


    /**
     * Lets AntX's lenient stringifier generate something useful.
     */
    public String toString()
    {
        return m_label;
    }



    /**
     * Verifies we're in a live project (created from build
     * process).
     **/
    protected final void verifyInProject_(String calr)
    {
        if (getProject()==null) {
            String ermsg = AntX.uistrs().get("cv.verifyInP","UncloneableNothingType:",calr);
            log(ermsg, Project.MSG_ERR);
            throw new IllegalStateException(ermsg);
        }
    }


    private String m_label="";
    private String m_typeName;//NB: lazy-inited
}


/* end-of-UncloneableNothingType.java */
