/**
 * $Id: IterationTest.java 187 2007-03-25 17:59:16Z ssmc $
 * Copyright 2004,2007 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://antxtras.sf.net/          EMAIL- jware[at]users[dot]sourceforge[dot]net
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  java.util.Map;

import  org.apache.tools.ant.Project;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.FixtureExaminer;
import  com.idaremedia.antx.Iteration;
import  com.idaremedia.antx.helpers.SIDs;
import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Test suite for {@linkplain com.idaremedia.antx.Iteration Iteration} extension.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004,2007 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5.1
 * @.safety   single
 * @.group    impl,test
 **/

public final class IterationTest extends HTC 
{
    /**
     * Create new IterationTest testcase.
     **/
    public IterationTest(String methodName)
    {
        super("(Plain)Iteration::",methodName);
    }


    /**
     * Create full test suite for Iteration.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(IterationTest.class);
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        if ("testBaseline".equals(getName())) {
            Iteration.set(new FakeIteration());
            configureProjectFromResource("fakeiteration.xml");
        } else {
            Iteration.reset();
            /* Required for Ant 1.7's version of BuildFileTest (requires at least 1 target). */
            configureProjectFromResource("standardblank.xml"); 
        }
    }


// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
        runTarget("AllTests");
    }


    public void testSetTopLevelFlatProperty_AntX05()
    {
        String key0 = SIDs.next();
        String key1 = key0+".b";
        
        assertNull(Iteration.getProperty(key0));
        Iteration.setProperty(key0,"helloworld");
        assertEquals(new String("h"+"elloworld"),Iteration.getProperty(key0));
        String val0 = String.valueOf(Iteration.getProperty(key0));

        Iteration.setProperty(key1,new Integer(111));
        assertEquals(val0,Iteration.getProperty(key0));
        assertTrue(Iteration.getProperty(key1) instanceof Integer);
        assertEquals("111",String.valueOf(Iteration.getProperty(key1)));

        Iteration.removeProperty(key0);
        assertNil(Iteration.getProperty(key0));
        assertNotNil(Iteration.getProperty(key1));
        
        Iteration.setProperty(key1, new RuntimeException("imbroken"));
        assertTrue(Iteration.getProperty(key1) instanceof RuntimeException);
        assertNil(Iteration.getProperty(key0));
        
        Iteration.removeProperty(key1);
        assertNil(Iteration.getProperty(key1));
    }


    private void verifyFixture00(String category0, String category1, String key0)
    {
        assertNil(Iteration.getProperty(category0));
        assertNil(Iteration.getProperty(category0,key0));
        assertNil(Iteration.getProperty(key0));
        assertNil(Iteration.getProperty(category1));
    }


    public void testSetTopLevelNestedProperty_AntX05()
    {
        String category0 = SIDs.next("ITCAT");
        String key0 = SIDs.next();
        String category1 = key0+".ITCAT";
        
        verifyFixture00(category0,category1,key0);
        
        Iteration.setProperty(category0,key0,"Hola Mundo");
        assertTrue(Iteration.getProperty(category0) instanceof Map);
        assertEquals(new String("Hola "+"Mundo"),Iteration.getProperty(category0,key0));
        assertNil(Iteration.getProperty(key0));
        
        Iteration.setProperty(category1,"flat");
        Iteration.setProperty(category1,key0,"ERROR");
        assertEquals("flat",Iteration.getProperty(category1));
        assertNil(Iteration.getProperty(key0));
        assertNil(Iteration.getProperty(category0,category1));
        
        Iteration.removeProperty(category1);
        Iteration.setProperty(category1,key0,"OK!");
        assertTrue(Iteration.getProperty(category1) instanceof Map);
        assertIdent("OK!",Iteration.getProperty(category1,key0));
        
        Iteration.removeProperty(category1,key0);
        Object o = Iteration.getProperty(category1);
        assertTrue(o instanceof Map);
        assertEqual(0,((Map)o).size(),"map size");
        
        Iteration.setProperty(category1,category0);//bad idea generally
        assertIdent(Iteration.getProperty(category1),category0);
        Iteration.removeProperty(category0);
        Iteration.removeProperty(category1);
        
        verifyFixture00(category0,category1,key0);
    }
    
    
    public void testTopLevelValueURIBuiltin_AntX05()
    {
        final Project P = new Project();
        Object itid = Iteration.getProperty("Iteration.ITID");
        assertNotNil(itid,"Iteration.ITID property");
        assertIdent(itid,FixtureExaminer.findValue(P,"$itprop:Iteration.ITID",""));

        String category0 = SIDs.next("ITCAT");
        String key0 = SIDs.next();
        String refkey0 = "$itproperty:"+category0+"->"+key0;
        
        assertNil(FixtureExaminer.findValue(P,refkey0,""),refkey0);
        Iteration.setProperty(key0,"HelloWorld");
        Iteration.setProperty(category0,key0,"ByeWorld");
        assertEqual("HelloWorld",FixtureExaminer.findValue(P,"$itproperty:"+key0,""));
        assertEqual("ByeWorld",FixtureExaminer.findValue(P,refkey0,""));
        
        Iteration.removeProperty(category0);
        Iteration.removeProperty(key0);
    }
    
    
    public void testFailGetNullProperties_AntX05()
    {
        try {
            Iteration.getProperty(null);
            fail("Should not be able to get NULL property name");
        } catch(IllegalArgumentException Xpected) {
            assertExpected(Xpected,"property name");
        }
        try {
            Iteration.getProperty(null,"item0");
            fail("Should not be able to get NULL category name");
        } catch(IllegalArgumentException Xpected) {
            assertExpected(Xpected,"category");
        }
        try {
            Iteration.getProperty("category0",null);
            fail("Should not be able to get NULL category property");
        } catch(IllegalArgumentException Xpected) {
            assertExpected(Xpected,"property name");
        }
    }


    public void testFailPutNullProperties_AntX05()
    {
        try {
            Iteration.setProperty(null,"value0");
            fail("Should not be able to set NULL property name");
        } catch(IllegalArgumentException Xpected) {
            assertExpected(Xpected,"property name");
        }
        try {
            Iteration.setProperty(null,"item0","value0");
            fail("Should not be able to set NULL category name");
        } catch(IllegalArgumentException Xpected) {
            assertExpected(Xpected,"category");
        }
        try {
            Iteration.setProperty("category0",null,"value0");
            fail("Should not be able to set NULL category property");
        } catch(IllegalArgumentException Xpected) {
            assertExpected(Xpected,"property name");
        }
    }


    public void testFailRemoveNullProperties_AntX05()
    {
        try {
            Iteration.removeProperty(null);
            fail("Should not be able to remove NULL property name");
        } catch(IllegalArgumentException Xpected) {
            assertExpected(Xpected,"property name");
        }
        try {
            Iteration.removeProperty(null,"item0");
            fail("Should not be able to remove NULL category name");
        } catch(IllegalArgumentException Xpected) {
            assertExpected(Xpected,"category");
        }
        try {
            Iteration.removeProperty("category0",null);
            fail("Should not be able to remove NULL category property");
        } catch(IllegalArgumentException Xpected) {
            assertExpected(Xpected,"property name");
        }
    }
    

    public void testHaveAccessToInheritedIterationFields_AntX05()
        throws Exception
    {
        FakeIteration out = new FakeIteration();
        String value = out.getInheritedField("m_itid");
        assertEqual("java.lang.String",value,"inherited 'm_itid' field");
        value = out.getInheritedField("m_defaultsINSTANCE");
        assertEqual("com.idaremedia.antx.Defaults",value,"inherited 'm_defaultsINSTANCE' field");
    }
}

/* end-of-IterationTest.java */