/**
 * $Id: FakeIterationCheck.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  org.apache.tools.ant.Task;

import  com.idaremedia.antx.ut.HTC;

/**
 * Task to test that the FakeIteration object was initialized as expected.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,test
 **/

public final class FakeIterationCheck extends Task
{
    public FakeIterationCheck()
    {
    }
    
    
    public void setField(String fieldName)
    {
        m_fieldName = fieldName;
    }
 
 
    public void setValue(String fieldValue)
    {
        m_fieldValue = fieldValue;
    }


    public void execute()
    {
        if (m_fieldName!=null) {
            if (m_fieldName.startsWith("private")) {
                HTC.assertEqual(FakeIteration.privateField(),m_fieldValue,"privateField");
            } else if (m_fieldName.startsWith("protected")) {
                HTC.assertEqual(FakeIteration.protectedField(),m_fieldValue,"protectedField");
            } else if (m_fieldName.startsWith("inherited:")) {
                String fieldvalue=null;
                try {
                    fieldvalue = FakeIteration.inheritedField(m_fieldName);
                } catch(Exception anyX) {
                    HTC.failASAP(anyX);
                }
                HTC.assertEqual(fieldvalue,m_fieldValue,"inheritedField");
            } else {
                HTC.assertEqual(FakeIteration.getf().publicField,m_fieldValue,"publicField");
            }
        }
    }


    private String m_fieldName,m_fieldValue="blank";
}

/* end-of-FakeIterationCheck.java */