/**
 * $Id: FakeErrorTask.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.tests;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Task;

import  com.idaremedia.antx.ErrorSnapshot;
import  com.idaremedia.antx.helpers.Strings;
import  com.idaremedia.antx.helpers.Tk;

/**
 * Test helper task that creates an exception or ErrorSnapshot and saves the current
 * project as a reference. Usually defined &lt;fakeerror&gt;
 * <p>
 * <b>Examples:</b><pre>
 *    <fakeerror errid="the.err" message="I'm dying here"/>
 *    <fakeerror errid="err.snapshot" snapshot="yes"/>
 *    <fakeerror errid="err.snapshot" snapshot="yes" properties="is.debug,is.opt"/>
 * </pre>
 *
 * @since    JWare/AntX 0.3
 * @author   ssmc, &copy;2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test,helper
 **/

public class FakeErrorTask extends Task
{
    public FakeErrorTask()
    {
    }

    public void setErrId(String refid)
    {
        m_errId = refid;
    }

    public String getErrId()
    {
        return m_errId;
    }

    public void setMsg(String msg)
    {
        m_msg = msg;
    }

    public final void setMessage(String msg)
    {
        setMsg(msg);
    }

    public String getMsg()
    {
        return m_msg;
    }

    public void setSnapshot(boolean isErrSnapshot)
    {
        m_isThrownX = !isErrSnapshot;
    }

    public boolean isThrown()
    {
        return m_isThrownX;
    }

    public boolean isSnapshot()
    {
        return !m_isThrownX;
    }

    public void setProperties(String nameList)
    {
        m_propertiesNameList = nameList;
    }

    public String getProperties()
    {
        return m_propertiesNameList;
    }

    public void execute()
    {
        if (m_isThrownX) {
            BuildException X = new BuildException(getMsg(),getLocation());
            getProject().addReference(getErrId(),X);
        } else {
            ErrorSnapshot X = new ErrorSnapshot(this);
            X.setName(getErrId());
            X.setComment(getMsg());
            if (getProperties()!=null) {
                String lc = Tk.lowercaseFrom(getProperties());
                if (Strings.ALL.equals(lc)) {
                    X.captureAllProperties();
                } else if (Strings.USER.equals(lc)) {
                    X.captureUserProperties();
                } else {
                    X.captureProperties(getProperties());
                }
            }
            getProject().addReference(getErrId(),X);
        }
    }

    private String m_errId = "the.err";
    private boolean m_isThrownX = true;
    private String m_msg = "Aarrrghh";
    private String m_propertiesNameList;
}

/* end-of-BarfFactoryTask.java */
