/**
 * $Id: StrictInnerTaskSet.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.starters;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;

/**
 * Superclass of all "special" helper tasks within a strict outer taskset. Special
 * helper tasks are usually tasksets executed in response to a particular kind-of event
 * like a caught build exception or a matching case check. Note a strict inner class
 * is by definition quiet except an alternative "go" API isn't necessary since the inner
 * task can only be nested in a prescribed outer task that controls it.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @see      StrictOuterTask
 **/

public abstract class StrictInnerTaskSet extends TaskSet implements StrictInnerTask
{
    /**
     * Creates a new strict inner task. Must be associated with an
     * enclosing task before functional.
     **/
    protected StrictInnerTaskSet(String iam)
    {
        super(iam);
    }

    /**
     * Creates a new strict inner task with custom configuration delay.
     * Must be associated with an enclosing task before functional.
     **/
    protected StrictInnerTaskSet(String iam, boolean delayConfiguration)
    {
        super(iam,delayConfiguration);
    }


    /**
     * Returns this helper's enclosing block task.
     **/
    public final StrictOuterTask getEnclosingTask()
    {
        return m_enclosingTask;
    }


    /**
     * Initializes this helper's enclosing block task. For now can
     * only be done by a default AntX block task definitions.
     **/
    public final void setEnclosingTask(StrictOuterTask owner)
    {
        m_enclosingTask = owner;
    }


    /**
     * Ensures this helper is enclosed within a block task before
     * it can execute.
     * @throws BuildException if not in valid target/project or not nested
     *         in the expected enclosing taskset.
     **/
    protected void verifyCanExecute_(String calr)
        throws BuildException
    {
        super.verifyCanExecute_(calr);

        if (getEnclosingTask()==null) {
            String ermsg = uistrs().get("task.only.in.outer",getTaskName());
            log(ermsg, Project.MSG_ERR);
            throw new BuildException(ermsg,getLocation());
        }
    }


    private StrictOuterTask m_enclosingTask;
}

/* end-of-StrictInnerTaskSet.java */
