/**
 * $Id: BuildListenerSkeleton.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.starters;

import  org.apache.tools.ant.BuildEvent;
import  org.apache.tools.ant.SubBuildListener;

/**
 * Stub implementation of a Ant build listener.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,helper
 **/

public abstract class BuildListenerSkeleton
    implements SubBuildListener
{
    /**
     * Initializes a new build lister stub.
     **/
    protected BuildListenerSkeleton()
    { }


    /**
     * Called before any targets started; does nothing.
     **/
    public void buildStarted(BuildEvent event)
    { }


    /**
     *  Called after the last target finished; does
     * nothing.
     **/
    public void buildFinished(BuildEvent event)
    { }


    /**
     * Called before any sub-build targets started; 
     * does nothing.
     * @since JWare/AntX 0.5
     **/
    public void subBuildStarted(BuildEvent event)
    { }


    /**
     * Called after the last sub-build target finished;
     * does nothing.
     * @since JWare/AntX 0.5
     **/
    public void subBuildFinished(BuildEvent event)
    { }



    /**
     * Called when a target is started; does nothing.
     **/
    public void targetStarted(BuildEvent event)
    { }


    /**
     * Called after a target has finished; does nothing.
     **/
    public void targetFinished(BuildEvent event)
    { }


    /**
     * Called when a task is started; does nothing.
     **/
    public void taskStarted(BuildEvent event)
    { }


    /**
     * Called when a task has finished; does nothing.
     **/
    public void taskFinished(BuildEvent event)
    { }


    /**
     *  Called whenever a message is logged; does nothing.
     **/
    public void messageLogged(BuildEvent event)
    { }
}

/* end-of-BuildListenerSkeleton.java */
