/**
 * $Id: NullPrintStream.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.ownhelpers.io;

import  java.io.PrintStream;

/**
 * Null-proxy for a PrintStream. Mucho more efficient that creating a regular
 * PrintStream around a {@linkplain NullStream}.
 *
 * @since     JWare/AntX 0.4
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   multiple
 * @.group    impl,helper
 * @.pattern  JWare.NullProxy
 * @see       NullStream
 **/

public final class NullPrintStream extends PrintStream
{
    /**
     * Proxy for the standard System.err stream.
     **/
    public static final NullPrintStream err= new NullPrintStream();


    /**
     * Proxy for the standard System.out stream.
     **/
    public static final NullPrintStream out= new NullPrintStream();



    /**
     * Initialize a new null proxy for a print stream.
     **/
    public NullPrintStream() {
        super(new NullStream());
    }


    // Inherit javadocs -------------------------------------------

    public void close() {
    }

    public void flush() {
    }

    public void print(boolean b) {
    }

    public void print(char c) {
    }

    public void print(char[] c) {
    }

    public void print(double d) {
    }

    public void print(float f) {
    }

    public void print(int i) {
    }

    public void print(long l) {
    }

    public void print(Object o) {
    }

    public void print(String s) {
    }

    public void println() {
    }

    public void println(boolean b) {
    }

    public void println(char c) {
    }

    public void println(char[] c) {
    }

    public void println(double d) {
    }

    public void println(float f) {
    }

    public void println(int i) {
    }

    public void println(long l) {
    }

    public void println(Object o) {
    }

    public void println(String s) {
    }

    public void write(byte[] buf) {
    }

    public void write(byte[] buf, int off, int len) {
    }

    public void write(int b) {
    }

    public boolean checkError() {
        return false;
    }
}

/* end-of-NullPrintStream.java */
