/**
 * $Id: ParentDirTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.mktemp.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Testsuite for the {@linkplain com.idaremedia.antx.mktemp.ParentDirTask
 * ParentDirTask} class.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,test
 **/

public final class ParentDirTaskTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create a new ParentDirTask testcase.
     **/
    public ParentDirTaskTest(String methodName)
    {
        super("ParentDirTask::",methodName);
    }


    /**
     * Create full test suite for ParentDirTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(ParentDirTaskTest.class);
    }


    /**
     * Create baseline test suite for ParentDirTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("parentdir.xml");
    }


// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testRegularFilePaths_AntX05()
    {
        runTarget("testRegularFilePaths_AntX05");
    }

    public void testFileURLs_AntX05()
    {
        runTarget("testFileURLs_AntX05");
    }

    public void testResourceURI_AntX05()
    {
        runTarget("testResourceURI_AntX05");
    }

    public void testTmpURI_AntX05()
    {
        runTarget("testTmpURI_AntX05");
    }
    
    public void testParentOfRoot_AntX05()
    {
        runTarget("testParentOfRoot_AntX05");
    }
    
    public void testUpdatePropertyRequired_AntX05()
    {
        runTarget("testUpdatePropertyRequired_AntX05");
    }
    
    public void testPopUpMultipleLevels_AntX05()
    {
        runTarget("testPopUpMultipleLevels_AntX05");
    }
    
    public void testAppendSubPath_AntX05()
    {
        runTarget("testAppendSubPath_AntX05");
    }
}

/* end-of-ParentDirTaskTest.java */