/**
 * $Id: DirectoryListing.java 186 2007-03-16 13:42:35Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.mktemp;

import  java.io.File;
import  java.util.Iterator;

import  org.apache.tools.ant.DirectoryScanner;
import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.AntXFixture;
import  com.idaremedia.antx.ownhelpers.LocalTk;
import  com.idaremedia.antx.starters.ListFriendly;
import  com.idaremedia.antx.starters.StringItemList;

/**
 * Directory listing data type. Created by the {@linkplain ListDirTask} but functional
 * like any other {@linkplain ListFriendly} item list.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    impl,helper
 **/

public final class DirectoryListing extends StringItemList implements ListFriendly
{
    /**
     * Initializes a new directory list item list.
     * @param basenameOnly <i>true</i> if this is a list of base names.
     **/
    DirectoryListing(boolean basenameOnly)
    {
        super(AntX.mktemp+"DirectoryList:");
        m_basenameOnly = basenameOnly;
    }



    /**
     * Adds a set of included files or directory to this listing.
     * @param list the included list (non-null)
     * @param ds active directory scanner (non-null)
     **/
    void addIncludes(String[] list, DirectoryScanner ds)
    {
        LocalTk.resolveAllFilesOrDirs(list,ds,m_basenameOnly);
        for (int i=0;i<list.length;i++) {
            addItemFinal(list[i]);
        }
    }



    /**
     * Returns a path-separator delimited list of this list's contents.
     **/
    public String stringFrom(Project theProject)
    {
        final String theDelimiter = File.pathSeparator;
        StringBuffer sb = AntXFixture.newStringBuffer();

        int N=0;
        Iterator itr= readonlyStringIterator(theProject);
        while (itr.hasNext()) {
            if (N>0) {
                sb.append(theDelimiter);
            }
            sb.append(itr.next());
            N++;
        }
        itr=null;
        return sb.substring(0);
    }
    

    private boolean m_basenameOnly;
}

/* end-of-DirectoryListing.java */