/**
 * $Id: MessageValueURIHandler.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.init;

import  com.idaremedia.apis.UIStringManager;

import  com.idaremedia.antx.Iteration;
import  com.idaremedia.antx.UISMContext;
import  com.idaremedia.antx.apis.Requester;
import  com.idaremedia.antx.helpers.Strings;
import  com.idaremedia.antx.helpers.Tk;
import  com.idaremedia.antx.starters.ValueURIHandlerSkeleton;

/**
 * Simple value URI handler that returns the named message from an AntX
 * resource bundle. The messages resource bundle should be activated before any URI 
 * refers to it (see <span class="src">&lt;managebundles&gt;</span> or
 * <span class="src">&lt;overlay-msgs&gt;</span>). This handler is not installed
 * automatically by the AntX runtime, you must install it explicitly like the example
 * below. Message value URIs are often linked to either the <span class="src">$str:</span>
 * or the <span class="src">$message:</span> scheme.
 * <p/>
 * You can specify up to two message template arguments (for locations {2} and
 * {3}) by using a simple URI form like: <span class="src">$str:strid[?arg2[,,arg3]]</span>.
 * Everything after the <span class="src">strid</span> is optional.
 * <p/>
 * To allow you to specify the two optional message arguments from property values,
 * the message URI handler understands the alternate "<span class="src">@(propertyname)</span>"
 * format in its fragment's query portion; see example below. Note that the message arguments
 * are separated by two commas like "<span class="src">,,</span>" <em>not</em> an
 * ampersand. This allows XML-based scripts to define arguments without the need to
 * encode the ampersand reserved for use with XML entities.
 * <p/>
 * <b>Example Usage:</b><pre>
 *    &lt;macrodef name="api-docs"&gt;
 *         &lt;attribute name="id"
 *                       default="${<b>$str:</b>label.id?@(id)}"/&gt;
 *         &lt;attribute name="label"
 *                       default="${<b>$str:</b>label.main?@(id),,@(rev)}"/&gt;
 *         ...
 * 
 *   -- To Install --
 *    &lt;manageuris action="install"&gt;
 *       &lt;parameter name="str"
 *             value="com.idaremedia.antx.init.MessageValueURIHandler"/&gt;
 *       &lt;parameter name="message"
 *             value="com.idaremedia.antx.init.MessageValueURIHandler"/&gt;
 *    &lt;/manageuris&gt;
 * </pre>
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   multiple
 * @.group    api,helper
 **/

public final class MessageValueURIHandler extends ValueURIHandlerSkeleton
{
    /**
     * Initializes a new message value URI handler.
     **/
    public MessageValueURIHandler()
    {
    }
 

    /**
     * Tries to load+form the named message string from the nearest UI
     * string manager. If no string manager is installed, this method
     * will use the default string manager. 
     **/
    public String valueFrom(String uriFragment, String fullUri, Requester clnt)
    {
        String msgid = uriFragment;
        
        String arg0= clnt.getName();
        if (arg0==null) {
            arg0= Strings.UNDEFINED;
        }

        boolean shorten= Iteration.defaultdefaults().isShortLocationsEnabled();
        String arg1= Tk.shortStringFrom(shorten, clnt.getLocation());
        
        Object[] args = new Object[]{arg0,arg1};

        int i = uriFragment.lastIndexOf("?");
        if (i>0){
            msgid = uriFragment.substring(0,i++);
            if (i<uriFragment.length()) {
                String arg2=null,arg3=null;
                arg2 = uriFragment.substring(i);
                i = arg2.indexOf(",,");
                if (i>0) {
                    if ((i+2)<arg2.length()) {
                        arg3 = arg2.substring(i+2);
                    }
                    arg2 = arg2.substring(0,i);
                }
                arg2 = Tk.resolveString(clnt.getProject(),arg2,true);
                if (arg3!=null) {
                    arg3 = Tk.resolveString(clnt.getProject(),arg3,true);
                    args = new Object[]{arg0,arg1,arg2,arg3};
                } else {
                    args = new Object[]{arg0,arg1,arg2};
                }
            }
            
        }
        UIStringManager sm = UISMContext.getStringManagerNoNull();
        return sm.mget(msgid,args,msgid);
    }
}

/* end-of-MessageValueURIHandler.java */