/**
 * $Id: EchoBundleTask.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.init;

import  java.io.IOException;
import  java.io.OutputStream;
import  java.util.Properties;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.apis.TestScriptComponent;
import  com.idaremedia.antx.starters.EchoThingTask;

/**
 * Helper task to display contents of a {@linkplain UISMBundle}. Mostly used for debugging
 * and during unit tests. Example usage:<pre>
 *  &lt;printbundle message="default-msgs" bundleid="default-msgs"/&gt;
 *
 *  &lt;printbundle message="default-msgs" bundleid="default-msgs"
 *          tofile="/tmp/default-msgs.properties" if="debug.msg.bundles"/&gt;
 * </pre>
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,helper
 * @see      UISMBundle
 **/

public final class EchoBundleTask extends EchoThingTask
    implements TestScriptComponent
{
    /**
     * Initializes new EchoBundleTask.
     **/
    public EchoBundleTask()
    {
        super(AntX.print);
    }



    /**
     * Initializes enclosed CV-labeled EchoBundleTask.
     **/
    public EchoBundleTask(String iam)
    {
        super(iam);
    }



    /**
     * Initializes the UISMBundle reference id for this task.
     **/
    public void setBundleId(String refId)
    {
        setThingRefId(refId);
    }



    /**
     * Returns the UISMBundle's reference id; can be <i>null</i>
     * if never set. Required for task to execute properly.
     **/
    public final String getBundleRefId()
    {
        return getThingRefId();
    }



    /**
     * Returns the actual {@linkplain UISMBundle} echoed by this
     * task. Never returns <i>null</i>.
     * @throws BuildException if bundle refid undefined or not a UISMBundle
     **/
    public final UISMBundle getReferencedBundle()
        throws BuildException
    {
        return (UISMBundle)getReferencedThing
            (UISMBundle.class,"task.uism.bad.refid");
    }



    /**
     * Ensures we're in a valid target/project and have a valid bundle
     * reference id.
     * @throws BuildException if verify fails
     **/
    protected void verifyCanExecute_(String calr)
    {
        super.verifyCanExecute_(calr);
        getReferencedBundle();//NB: ensures refid -> UISMBundle
    }



    /**
     * Writes the referenced bundle as a properties object to this task's
     * specified output stream (file|stdout).
     * @throws BuildException if file I/O occurs
     **/
    protected void echoThing() throws BuildException
    {
        OutputStream os = getOutputStream();
        Properties msgs = getReferencedBundle().newProperties(null);

        try {
            msgs.store(os,getMsg());

            if (tryAntLog(os)) {
                log(getAntLogString(os),getMsgLevel().getNativeIndex());
            }

        } catch(IOException ioX) {
            String ermsg = uistrs().get("task.echo.unable");
            log(ermsg,Project.MSG_ERR);
            throw new BuildException(ermsg,getLocation());

        } finally {
            try { os.close(); } catch(Exception X){/*burp*/}
            os=null;
            msgs.clear();
            msgs=null;
        }
    }
}

/* end-of-EchoBundleTask.java */
