/**
 * $Id: BundlePrinter.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.init;

import  java.io.IOException;
import  java.io.OutputStream;
import  java.util.Properties;

import  com.idaremedia.antx.print.DisplayRequest;
import  com.idaremedia.antx.print.DisplayStrategy;

/**
 * Default strategy for printing a {@linkplain UISMBundle UISMBundle} to an output stream.
 * Basically dumps the resource bundle's underlying properties object to the stream.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,helper
 * @see      EchoBundleTask
 **/

public final class BundlePrinter implements DisplayStrategy
{
    /**
     * Initializes a new BundlePrinter.
     **/
    public BundlePrinter()
    {
    }


    /**
     * Copies the referenced bundle's underlying Properties information
     * to given output stream.
     * @param info display information (non-null)
     * @param os the output stream (non-null)
     * @throws IOException if any I/O error occurs
     **/
    public void print(final DisplayRequest info, OutputStream os)
        throws IOException
    {
        Object thing = info.getObjectToBeDisplayed();

        if (thing instanceof UISMBundle) {
            Properties msgs = ((UISMBundle)thing).newProperties(null);
            msgs.store(os,info.getName());
            msgs.clear();
            msgs = null;
        }
    }
}

/* end-of-BundlePrinter.java */
