/**
 * $Id: ArrayIterator.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2000-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.helpers;

import  java.lang.reflect.Array;
import  java.util.Enumeration;
import  java.util.Iterator;
import  java.util.NoSuchElementException;

/**
 * Iterator and Enumeration implementation for a Java array.
 *
 * @since    JWare/core 0.5
 * @author   ssmc, &copy;2000-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,helper
 * @.pattern GoF.Adapter
 **/

public class ArrayIterator extends NoRemoveIteratorSkeleton implements Iterator, Enumeration
{
    private final Object m_array;
    private final int m_len;
    private int m_i;

    /**
     * Creates new iterator for given array.
     * @param array array to iterate (non-null array)
     **/
    public ArrayIterator(Object array)
    {
        if (array==null || !array.getClass().isArray()) {
            throw new IllegalArgumentException("ctor- nonzro ary reqd");
        }
        m_array = array;
        m_len = Array.getLength(array);
    }


    /**
     * Returns <i>true</i> if more elements in array to iterate.
     **/
    public boolean hasNext()
    {
        return m_i < m_len;
    }


    /**
     * Returns <i>true</i> if more elements in array to iterate.
     **/
    public final boolean hasMoreElements()
    {
        return hasNext();
    }


    /**
     * Returns next object in array and advances iteration by one.
     * @throws NoSuchElementException if iteration finished
     **/
    public Object next()
    {
        if (m_i>=m_len) {
            throw new NoSuchElementException();
        }
        return Array.get(m_array,m_i++);
    }


    /**
     * Same as {@linkplain #next}.
     **/
    public final Object nextElement()
    {
        return next();
    }


    /**
     * Returns index of last element returned returned by either
     * {@linkplain #next} or {@linkplain #nextElement}.
     **/
    public int nextIndex()
    {
        return (m_i>=m_len) ? m_len : m_i;
    }


    /**
     * Unsupported removal operation (arrays are immutable).
     * @throws java.lang.UnsupportedOperationException always
     **/
    public void remove()
    {
        throw new UnsupportedOperationException("Cannot remove slot from Java array");
    }
}

/* end-of-ArrayIterator.java */
