/**
 * $Id: InlineForEachTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.flowcontrol.call.InlineForEachTask
 * InlineForEachTask}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class InlineForEachTaskTest extends StepCallerTestSkeleton
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new InlineForEachTaskTest testcase.
     **/
    public InlineForEachTaskTest(String methodName)
    {
        super("InlineForEachTask::",methodName);
    }
    

    /**
     * Creates a test suite with a single test.
     **/
    public static TestSuite suiteOfOne(String testName)
    {
        TestSuite s = new TestSuite();
        s.setName("Suite-of-One:"+testName);
        s.addTest(new InlineForEachTaskTest(testName));
        return s;
    }


    /**
     * Create full test suite for InlineForEachTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(InlineForEachTaskTest.class);
        //return suiteOfOne("testBodyAsLocalMacroDef_AntX05");
    }


    /**
     * Create baseline test suite for InlineForEachTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected String getDefaultConfigureXMLFileName()
    {
        return "iforeach.xml";
    }


    final int verifyTargetsRanInLoop(String[] cursors, int ilastmatch)
    {
        String log= getLog();
        String match;
        int imatch;
        for (int i=0;i<cursors.length;i++) {
            match = "(at:"+cursors[i]+")";
            imatch = log.indexOf(match,ilastmatch);
            assertTrue("Expecting Log to contain \""+match+"\" from ["+ilastmatch+
                       "] but Log was \"" + log + "\"",
                       imatch>=0);
            ilastmatch = imatch+match.length();
        }
        return ilastmatch;
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void testPassEmptyTaskset()
    {
        runTargetNoOutput("testPassEmptyTaskset");
    }

    public void testFailBrokenLoopDefinitions()
    {
        runTarget("testBrokenLoops");
    }

    public void testInLoopControl()
    {
        runTarget("testInLoopControl");
        int from=0;
        from= verifyTargetsRanInLoop(new String[]{"0"},from);
        from= verifyTargetsRanInLoop(new String[]{"0","1","2"},from);
        from= verifyTargetsRanInLoop(new String[]{"0","2","4"},from);
        from= verifyTargetsRanInLoop(new String[]{"-1","0"},from);
    }

    public void testNestedLoops()
    {
        runTarget("testNestedLoops");
    }

    public void testNestedLoopsInSteps()
    {
        runTarget("testNestedLoopsInSteps");
    }
    
    public void testBodyAsLocalMacroDef_AntX05()
    {
        runTarget("testBodyAsLocalMacroDef_AntX05");
    }
    
    public void testNestedLoopsAsLocalMacroDef_AntX05()
    {
        runTarget("testNestedLoopsAsLocalMacroDef_AntX05");
    }
    
    public void testMixAndMatchLoopTypes_AntX05()
    {
        runTarget("testMixAndMatchLoopTypes_AntX05");
    }
    
    public void testHardLimits_AntX05()
    {
        runTarget("testHardLimits_AntX05");
    }
    
    public void testLocalForEachFromMacrodef_AntX05()
    {
        runTarget("testLocalForEachFromMacrodef_AntX05");
    }
}

/* end-of-InlineForEachTaskTest.java */
