/**
 * $Id: StopTask.java 186 2007-03-16 13:42:35Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol;

import  java.lang.reflect.Constructor;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Location;
import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.NoiseLevel;
import  com.idaremedia.antx.apis.BuildError;
import  com.idaremedia.antx.helpers.InnerString;
import  com.idaremedia.antx.helpers.Tk;
import  com.idaremedia.antx.ownhelpers.LocalTk;
import  com.idaremedia.antx.starters.MsgTask;

/**
 * Throws either a {@linkplain BuildException BuildException} or a
 * {@linkplain BuildError BuildError}. Usually defined as &lt;stop&gt; or &lt;stopbuild&gt;
 * <em>This task does not call System.exit</em>. Specifying a stop with "fatal=yes"
 * lets you bypass any enclosing protected taskset catch-clauses (their associated
 * <i>always</i> tasks are still executed however).
 * <p>
 * As of Ant 1.6, the StopTask's effectiveness has been greatly reduced. Because Ant
 * 1.6 will capture and unconditionally convert any <em>Throwable</em> to a
 * <span class="src">BuildException</span>, it is possible that in spite of a fatal
 * stop request, the enclosing Ant process will "keep going".
 * <p>
 * Some examples:<pre>
 *   &lt;stopbuild fatal="yes" msgid="log4j.required"/&gt;
 *   &lt;stop msgid="require.build.rules" with="my.MissingResourcesException"/&gt;
 *   &lt;stop message="Ant 1.5 or higher is required" unless="atleast.ant15.present"/&gt;
 * </pre>
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   api,infra
 **/

public class StopTask extends MsgTask
{
    /**
     * Initializes a new StopTask instance.
     **/
    public StopTask()
    {
        super(AntX.flow+"stop");
    }


    /**
     * Initializes a new CV-labeled StopTask instance.
     * @param iam CV-label (non-null)
     **/
    public StopTask(String iam)
    {
        super(iam);
    }


    /**
     * Updates the fallback default message of this task if none
     * has been defined. Only replaces default once. Moved from
     * 'setLocation' for Ant 1.6.1 and UnknownElement workability.
     * @since JWare/AntX 0.4
     **/
    public void init()
    {
        super.init();

        Location loc = getLocation();

        if (loc!=Location.UNKNOWN_LOCATION) {
            if (Tk.isWhitespace(getDefaultMsg())) {
                String locationString = uistrs().get
                    ("stop.defaultmsg",getTaskName(),LocalTk.purtyLocation(loc));
                addConfiguredDefaultMsg(new InnerString(locationString));
            }
        }
    }



    /**
     * Overridden to show that this task emits messages at the error
     * level by default.
     **/
    public NoiseLevel getDefaultMsgLevel()
    {
        return isFatal() ? NoiseLevel.FATAL : NoiseLevel.ERROR;
    }



    /**
     * Sets the fatal flag on this task. This task will generate (the more
     * unblockable) {@linkplain BuildError} when executed.
     **/
    public void setFatal(boolean fatal)
    {
        m_tryFatal = fatal;
    }


    /**
     * Returns <i>true</i> if this task will generate the more serious
     * {@linkplain BuildError BuildError} when executed.
     **/
    public final boolean isFatal()
    {
        return m_tryFatal;
    }


    /**
     * Define a custom exception {@linkplain BuildException BuildException}
     * class for this task to throw. The specified class must be a subclass
     * of BuildException with a constructor that takes a String (the message)
     * and a {@linkplain Location location}.
     * @param claz the exception class's name (non-null)
     **/
    public void setWith(Class claz)
    {
        require_(claz!=null,"setWith- nonzro clas");
        if (!BuildException.class.isAssignableFrom(claz)) {
            String ermsg = uistrs().get("stop.bad.throwclass",claz.getName());
            log(ermsg,Project.MSG_ERR);
            throw new BuildException(ermsg,getLocation());
        }
        m_throwClass = claz;
    }


    /**
     * Returns the custom exception class used by this task. Returns
     * <i>null</i> if never set.
     **/
    public final Class getWith()
    {
        return m_throwClass;
    }


    /**
     * Generates either a build exception or a build error if this
     * task's filter conditions (if/unless) permit.
     * @throws BuildException if not fatal
     * @throws BuildError if fatal
     **/
    public void execute()
    {
        verifyCanExecute_("execute");

        if (testIfCondition() && testUnlessCondition()) {
            String ermsg = getMsg();
            aboutToStop(ermsg);
            if (isFatal()) {
                throw new BuildError(ermsg,getLocation());
            }
            throw new_BuildException(ermsg,getLocation());
        }
    }


    /**
     * Called to generate feedback to build monitor(s). By default
     * just logs the message at this task's feedback noise level.
     * @param ermsg the event's feedback message (non-null)
     **/
    protected void aboutToStop(String ermsg)
    {
        log(ermsg, getMsgLevel().getNativeIndex());
    }


    /**
     * Factory method for a build exception thrown by this task.
     **/
    private BuildException new_BuildException(String ermsg, Location theLocation)
    {
        BuildException tbt=null;

        if (getWith()!=null) {
            Class claz= getWith();
            try {
                Constructor ctor= claz.getConstructor(DFLT_SIGNATURE);
                Object[] params = new Object[]{ermsg,theLocation};
                tbt = (BuildException)ctor.newInstance(params);
            } catch(Exception anyX) {
                log(uistrs().get("stop.cant.make.custom.reason",claz.getName(),
                                 anyX.getMessage()), Project.MSG_WARN);
            }
        }
        if (tbt==null) {
            tbt= new BuildException(ermsg,theLocation);
        }
        return tbt;
    }



    private boolean m_tryFatal;//NB:no
    private Class m_throwClass;


    /** Required constructor signature of custom exception class. **/
    protected static final Class[] DFLT_SIGNATURE= new Class[] {
        String.class, Location.class
    };
}

/* end-of-StopTask.java */
