/**
 * $Id: EmitConfigureTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.feedback.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.feedback.EmitConfigureTask EmitConfigureTask}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class EmitConfigureTaskTest extends EmitTestSkeleton
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new EmitConfigureTaskTest testcase.
     **/
    public EmitConfigureTaskTest(String methodName)
    {
        super("EmitConfigureTask::",methodName);
    }


    /**
     * Create full test suite for EmitConfigureTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(EmitConfigureTaskTest.class);
    }


    /**
     * Create baseline test suite for EmitConfigureTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();//new BaselineSuite(EmitConfigureTaskTest.class);
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected String getDefaultConfigureXMLFileName()
    {
        return "emitconf.xml";
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    static final String EMITCOUNT= "EmitCount";
    static final String TIMESTAMP_MARKER= "Helloworld from task";
    static final String HELLOWORLD_MARKER= "Helloworld";
    static final String BYEWORLD_MARKER= "Byeworld";

    public void testEmptyOK()
    {
        runTarget("testEmptyOK");
    }

    public void testDefaultEchoesToAnt_NOT()
    {
        String log= runTarget("testDefaultEchoesToAnt_NOT");
        assertFalse(log.indexOf("log4j")>=0, "Log4j-message *NOT* echoed to Ant");
    }

    public void testDefaultFroms_NOT()
    {
        String log = runTarget("testDefaultFroms_NOT");
        verifyOccurances(log,"From: ",0);
    }

    private void verifyTimestamping(String target)
    {
        String today = getTodayString();
        println("TODAY = ("+today+")");

        String log = runEchoedTarget(target,null);
        verifyOccurances(log,TIMESTAMP_MARKER,0);

        int N= getIntegerProperty(EMITCOUNT);
        String log4jLog = testAppender().getLog();
        verifyOccurances(log4jLog,TIMESTAMP_MARKER,N);
        verifyOccurances(log4jLog,today,getIntegerProperty("TimestampCount"));
    }

    public void testDefaultTimestamping()
    {
        verifyTimestamping("testTimestamping");
    }

    public void testDefaultTimestampingNested()
    {
        verifyTimestamping("testTimestampingNested");
    }

    public void testDefaultNoiseLevel()
    {
        String log = runEchoedTarget("testNoiseLevel",null);
        verifyOccurances(log,HELLOWORLD_MARKER,getIntegerProperty("AntLogCount"));
        String log4jLog = testAppender().getLog();
        verifyOccurances(log4jLog, HELLOWORLD_MARKER, getIntegerProperty(EMITCOUNT));

        testAppender().clearLog();

        log = runEchoedTarget("testNoiseLevelNested",null);
        verifyOccurances(log,HELLOWORLD_MARKER,getIntegerProperty("AntLogCount"));
        log4jLog = testAppender().getLog();
        verifyOccurances(log4jLog, HELLOWORLD_MARKER, getIntegerProperty(EMITCOUNT));

    }

    public void testUnwindingAfterFault()
    {
        String log = runEchoedTarget("testUnwindingAfterFault",null);
        verifyOccurances(log,BYEWORLD_MARKER,getIntegerProperty("AntLogCount"));
        String log4jLog= testAppender().getLog();
        verifyOccurances(log4jLog,BYEWORLD_MARKER,getIntegerProperty(EMITCOUNT));
    }

    public void testDefaultFrom()
    {
        String log = runEchoedTarget("testEmitterPassthru");
        int N= getIntegerProperty(EMITCOUNT);
        verifyOccurances(log,HELLOWORLD_MARKER,N);
        verifyOccurances(testAppender().getLog(), HELLOWORLD_MARKER, N);
    }

    public void testBlockingInheritance()
    {
        String log = runEchoedTarget("testBlockingInheritance");
        verifyOccurances(log,"From:",1);
        verifyOccurances(log,HELLOWORLD_MARKER,3);
        String log4jLog = testAppender().getLog();
        verifyOccurances(log4jLog,"From:",2);//+1 to root
        verifyOccurances(log4jLog,HELLOWORLD_MARKER,0);//+3 to root
    }

    public void testUnableToLoadBrokenConfiguration()
    {
        verifyCantLoadFile("broken_conf0.xml","Conflicting use of refid");
    }

    public void testCanUseFromParallelTasks()
    {
        runEchoedTarget("testCanUseFromParallelTasks");
    }

    public void testUsingDefaultsRef()
    {
        runEchoedTarget("testUsingDefaultsRef");
        String log4jLog = testAppender().getLog();
        verifyOccurances(log4jLog,HELLOWORLD_MARKER,3);//+1 to root
        verifyOccurances(log4jLog,"ant.version",3);
    }

    public void testTimestampFormat()
    {
        runEchoedTarget("testTimestampFormat",null);
        String log4jLog = testAppender().getLog();
        verifyOccurances(log4jLog,"Kaabllaamm:",getIntegerProperty("TimestampCount"));
    }

    public void testIncludeProperties()
    {
        runEchoedTarget("testIncludedProperties");
        int N= getIntegerProperty(EMITCOUNT);
        String log4jLog = testAppender().getLog();
        verifyOccurances(log4jLog,"p.outer=",N);
        verifyOccurances(log4jLog,"p.outer=Outside",2);
        verifyOccurances(log4jLog,"p.inner=",N);
        verifyOccurances(log4jLog,"p.inner=null",N-1);
    }

    public void testCannotReferToSelf()
    {
        runTarget("testCannotReferToSelf");
    }


    public void testCannotCallbackFromNestedTask()
    {
        runTarget("testCannotCallbackFromNestedTask");
    }


    public void testRelativeGroupings_AntX04()
    {
        runEchoedTarget("testRelativeGroupings_AntX04","AntX.Local");
        String log4jLog = testAppender().getLog();
        verifyOccurances(log4jLog, "Hello From Outer Shell",2);
        verifyOccurances(log4jLog, "Hola From Inner Shell",1);
        verifyOccurances(log4jLog,HELLOWORLD_MARKER,3);
    }
}

/* end-of-EmitConfigureTaskTest.java */
