/**
 * $Id: DefaultEmitConfiguration.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.feedback;

import  java.text.DateFormat;
import  java.util.Date;

import  com.idaremedia.apis.DiagnosticsEmitter;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.AntXFixture;
import  com.idaremedia.antx.NoiseLevel;
import  com.idaremedia.antx.helpers.DateTimeFormat;
import  com.idaremedia.antx.helpers.Tk;

/**
 * Class that embodies the AntX defaults for each EmitConfiguration attribute and
 * behavior. The root emitter used by the default configuration can be customized.
 * Just set the System property: {@linkplain AntX#DEFAULT_ROOT_CATEGORY_PROP
 * DEFAULT_ROOT_CATEGORY_PROP} to the desired root category's name.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,helper
 * @see      LJDiagnosticsEmitter
 * @see      EmitContext#getConfiguration
 **/

public final class DefaultEmitConfiguration implements EmitConfiguration
{
    /**
     * VM/ClassLoader shareable singleton.
     **/
    public final static DefaultEmitConfiguration INSTANCE=
        new DefaultEmitConfiguration();


    /**
     * Initializes a new default configuration. Anyone can create a default
     * instance although the singleton is all that's needed for most uses.
     **/
    public DefaultEmitConfiguration()
    {
        String grpId= AntXFixture.getProperty(AntX.DEFAULT_ROOT_CATEGORY_PROP);

        if (!Tk.isWhitespace(grpId)) {
            m_rootEmitter = LJDiagnosticsEmitter.FACTORY.newEmitter(grpId);
            m_grpId = grpId;
        } else {
            m_rootEmitter = LJDiagnosticsEmitter.FACTORY.newEmitter();
            m_grpId = "";
        }
    }


    /**
     * Returns the default log4j category separator (dot).
     * @since JWare/AntX 0.3
     **/
    public String getGroupingPathSeparator()
    {
        return ".";
    }


    /**
     * Returns either the empty string or the custom root grouping defined
     * in the system properties. Never returns <i>null</i>.
     * @since JWare/AntX 0.3
     **/
    public String getFrom()
    {
        return m_grpId;
    }


    /**
     * Returns a wrapper for the root Log4j logger.
     **/
    public DiagnosticsEmitter getEmitter()
    {
        return m_rootEmitter;
    }


    /**
     * Returns a wrapper for the Log4j logger of specified
     * grouping. Note: this method creates a new emitter instance
     * everytime it is called.
     **/
    public DiagnosticsEmitter getCustomEmitter(String grpId)
    {
        return LJDiagnosticsEmitter.FACTORY.newEmitter(grpId);
    }


    /**
     * Returns the default runtime noiselevel.
     * @see com.idaremedia.antx.NoiseLevel#getDefault
     **/
    public NoiseLevel getNoiseLevel()
    {
        return NoiseLevel.getDefault(null);
    }


    /**
     * Updates incoming buffer with list of special properties values
     * to be recorded. No-op.
     **/
    public boolean getPropertiesNameList(StringBuffer list)
    {
        return false;
    }


    /**
     * Returns <i>false</i> to exclude timestamps by default.
     **/
    public boolean wantTimestamp()
    {
        return false;
    }


    /**
     * Returns the simple AntX ABBREVIATED formatted date-time
     * string. Format string like: "dd-MMM h:m a"
     * @param ms the timestamp (milliseconds)
     * @see DateTimeFormat#ABBREV
     **/
    public String stampify(long ms)
    {
        synchronized(m_defaultFormat) {
            return m_defaultFormat.format(new Date(ms));
        }
    }


    /**
     * Returns <i>true</i> so all emitted messages are also passed
     * through the standard Ant logging mechanism.
     **/
    public boolean shouldEcho()
    {
        return true;
    }


    private final DiagnosticsEmitter m_rootEmitter;
    private final String m_grpId;

    private final DateFormat m_defaultFormat=
        (DateFormat)DateTimeFormat.ABBREV.clone();//NB:our own sync
}

/* end-of-DefaultEmitConfiguration.java */
