/**
 * $Id: PerformTaskTask.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.construct;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.UnknownElement;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.AssertableTask;
import  com.idaremedia.antx.FixtureExaminer;
import  com.idaremedia.antx.apis.Requester;
import  com.idaremedia.antx.ownhelpers.TaskExaminer;
import  com.idaremedia.antx.ownhelpers.UEContainerProxy;

/**
 * Executes a previously cached task instance. The instance's reference is automatically
 * removed from the project's reference table unless the <span class="src">keep</span>
 * option is activated.
 * <p/>
 * <b>Example Usage:</b><pre>
 *    &lt;assign var="_junitinstance" value="${$random:string}"/&gt;
 *    &lt;createtask name="${$var:_junitinstance}"&gt;
 *       &lt;junit printsummary="yes" haltonfailure="yes"&gt;
 *          &#8230;
 *       &lt;/junit&gt;
 *    &lt;/createtask&gt;
 *    &#8230;<i>[alter task definition]</i>
 *    &lt;<b>performtask</b> name="${$var:_junitinstance}" keep="no"/&gt;
 *    &lt;unassign var="_junitinstance"/&gt;
 * </pre>
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   single
 * @.group    api,helper
 * @see       CreateTaskTask
 **/

public final class PerformTaskTask extends AssertableTask
{
    /**
     * Initializesa new performtask task instance.
     **/
    public PerformTaskTask()
    {
        super(AntX.utilities+"PerformTaskTask:");
    }



    /**
     * Tells this editor the reference id of the task under construction.
     * This task should've been installed by the AntX task creator method.
     * @param refId reference id of task under construction (non-null)
     **/
    public void setName(String refId)
    {
        require_(refId!=null,"setName- nonzro refid");
        m_itemUC = (UEContainerProxy)FixtureExaminer.getReferencedObject(getProject(), 
            new Requester.ForComponent(this), refId, UEContainerProxy.class);
        m_itemUCRefId = refId;
    }



    /**
     * Tells this task whether it should clear the task under construction
     * after it's been performed (the default). Only keep components that
     * can be reset.
     * @param keepIt <i>true</i> to keep task under construction
     **/
    public void setKeep(boolean keepIt)
    {
        m_purgeRefId = !keepIt;
    }



    /**
     * Ensures the referenced item under construction's proxy is performed.
     * If the proxy is to be kept, a <em>copy</em> of the proxy is performed;
     * the original is left intact.
     * @see #setKeep setKeep(&#8230;)
     */
    public void execute()
    {
        verifyCanExecute_("exec");

        if (m_purgeRefId) {
            getProject().getReferences().remove(m_itemUCRefId);
            m_itemUCRefId = null;
        }
        UnknownElement ue = m_itemUC.getUE();
        if (!m_purgeRefId) {
            ue = TaskExaminer.copyUEProxy(ue,getProject(),null);
        }
        ue.setLocation(getLocation());
        ue.perform();
        m_itemUC = null;
    }



    /**
     * Ensures we've been given a reference to a task to perform.
     */
    protected void verifyCanExecute_(String calr)
    {
        verifyInProject_(calr);

        if (m_itemUC==null) {
            String ermsg = uistrs().get("task.needs.name", getTaskName());
            log(ermsg,Project.MSG_ERR);
            throw new BuildException(ermsg,getLocation());
        }
    }


    private UEContainerProxy m_itemUC;//item under construction (non-null after name known)
    private String m_itemUCRefId;
    private boolean m_purgeRefId=true;//Remove task under construction from project
}

/* end-of-PerformTaskTask.java */