/**
 * $Id: RuleUserHandle.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition.solo;

/**
 * Luggage that carries around a shareable condition's caller's information.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,infra
 * @see      BuildRule
 * @.pattern JWare.Luggage
 **/

final class RuleUserHandle
{
    /**
     * Initializes new empty handle (done by factory).
     **/
    RuleUserHandle()
    {
    }

    /**
     * Sets the current thread's frontmost rule user.
     * @param c new frontmost caller (can be <i>null</i>)
     * @return the previous rule user (can be <i>null</i>)
     **/
    ShareableConditionUser setCaller(ShareableConditionUser c)
    {
        ShareableConditionUser old = m_ruleUser;
        m_ruleUser = c;
        return old;
    }


    /**
     * Returns the current thread's frontmost caller.
     * Can return <i>null</i>.
     **/
    ShareableConditionUser getCaller()
    {
        return m_ruleUser;
    }


    /* Seekrit member. */
    private ShareableConditionUser m_ruleUser;


    // ---------------------------------------------------------------------------------------
    /**
     * Factory of thread-specific RuleUserHandles.
     * @since    JWare/AntX 0.2
     * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
     * @version  0.5
     **/
    static final class Factory extends InheritableThreadLocal
    {
        /**
         * Returns a new RuleUserHandle.
         **/
        protected Object initialValue()
        {
            return new RuleUserHandle();
        }

        /**
         * Returns a new RuleUserHandle with reference to its parent's
         * rule caller.
         **/
        protected Object childValue(Object parentValue)
        {
            RuleUserHandle parentsJunk = (RuleUserHandle)parentValue;
            RuleUserHandle copy = new RuleUserHandle();
            if (parentsJunk!=null) {
                copy.setCaller(parentsJunk.getCaller());
            }
            return copy;
        }

        /**
         * Creates a new factory (only allowed from package's BuildRule).
         **/
        Factory()
        {
        }
    }
}

/* end-of-RuleUserHandle.java */
