/**
 * $Id: NeverTask.java 186 2007-03-16 13:42:35Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition.solo;

import  org.apache.tools.ant.Task;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.apis.TestScriptComponent;
import  com.idaremedia.antx.ownhelpers.LocalTk;

/**
 * Test task that unconditionally throws an standard Error. See the {@linkplain
 * com.idaremedia.antx.flowcontrol.StopTask StopTask} for a build-script variant of
 * Never. <b>Implementation Note:</b> a NeverTask throws a plain <code>java.lang.Error</code>
 * to differentiate it from an AntX BuildError. This allows tests to determine if an
 * expected BuildError was generated instead of a Never error.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  multiple
 * @.group   impl,test,helper
 * @see      com.idaremedia.antx.flowcontrol.StopTask
 **/

public final class NeverTask extends Task
    implements TestScriptComponent
{
    /**
     * Initializes a new NeverTask.
     **/
    public NeverTask()
    {
        super();
    }



    /**
     * Assigns this task a custom script message to display.
     * @param message the message (non-null)
     * @since JWare/AntX 0.5
     **/
    public void setMsg(String message)
    {
        m_errorMsg = message;
    }



    /**
     * Throws an Error.
     * @throws Error always
     **/
    public void execute()
    {
        String info = m_errorMsg;
        if (info==null) {
            String plocation = LocalTk.purtyLocation(getLocation());
            info = AntX.uistrs().get("never.msg",plocation);
        }
        throw new Error(info);
    }
    

    private String m_errorMsg;
}

/* end-of-NeverTask.java */
