/**
 * $Id: SimpleFlexCondition.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition;

import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.FlexString;
import  com.idaremedia.antx.parameters.IsA;

/**
 * A simple single-value condition whose unknown value can be either an inlined literal
 * value, a property's value, a variable's value, or a reference's value. Property,
 * variable, and reference values are determined at evaluation time.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,infra
 **/

public abstract class SimpleFlexCondition extends FlexCondition
    implements URIable
{
    /**
     * Initializes a new simple flex condition.
     **/
    protected SimpleFlexCondition()
    {
        super();
        m_impl.setLenient(false);
    }


    /**
     * Initializes a new CV-labeled simple flex condition.
     * @param iam CV-label (non-null)
     **/
    protected SimpleFlexCondition(String iam)
    {
        super(iam);
        m_impl.setLenient(false);
    }



    /**
     * Updates this condition's enclosing project; also updates
     * any nested project components.
     **/
    public void setProject(Project project)
    {
        super.setProject(project);
        m_impl.setProject(project);
    }



    /**
     * Returns the underlying value's flex string for this
     * condition. Never returns <i>null</i>.
     **/
    protected final FlexString getValueHelper()
    {
        return m_impl;
    }



    /**
     * Sets this condition's value as part of a value URI. To 
     * differentiate between a literal value, and a property, etc&#46;,
     * set the URI's query string to the correct "isa" setting;
     * for example: <span class="src">$isnumeric:@(it)?variable</span>.
     * @param uriFragment the value uri bits (non-null)
     * @since JWare/AntX 0.5
     */
    public void xsetFromURI(String uriFragment)
    {
        String flexvalue = uriFragment;
        IsA isa= getDefaultIsAForURI();

        int i = uriFragment.lastIndexOf("?");
        if (i>0) {
            flexvalue = uriFragment.substring(0,i++);
            if (i<uriFragment.length()) {
                String isaName = uriFragment.substring(i);
                isa = IsA.from(isaName,isa);
           }
        }
        switch (isa.getIndex()) {
            case IsA.PROPERTY_INDEX: {
                setProperty(flexvalue);
                break;
            }
            case IsA.VARIABLE_INDEX: {
                setVariable(flexvalue);
                break;
            }
            case IsA.REFERENCE_INDEX:{
                setReference(flexvalue);
                break;
            }
            default: {
                setLiteral(flexvalue);
            }
        }
    }


    /**
     * Marks this condition's as setting a literal for the 
     * default field set by a value URI.
     * @since JWare/AntX 0.5
     * @return IsA.LITERAL always.
     */
    protected IsA getDefaultIsAForURI()
    {
        return IsA.LITERAL;
    }


    private FlexString m_impl = new FlexString();
}

/* end-of-SimpleFlexCondition.java */
