/**
 * $Id: NoneSet.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition;

import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.AntX;

/**
 * Shortcut condition that returns <i>true</i> if none of the nested items (properties,
 * variables, references, etc.) are set in the project's environment.  Example usage:<pre>
 *   &lt;tally&gt;
 *     &lt;<b>noneset</b> trueproperty="clean.beginning"&gt;
 *       &lt;property name="build.number/&gt;
 *       &lt;property name="scrub.disable/&gt;
 *     &lt;/noneset&gt;
 *   &lt;/tally&gt;
 * </pre>
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   api,infra
 * @see      IsNotSet
 * @see      AnySet
 **/

public final class NoneSet extends CheckSetCondition implements URIable
{
    /**
     * Initializes new NoneSet condition; defaults to
     * returning <i>false</i>.
     **/
    public NoneSet()
    {
        super(AntX.rules+"noneset");
        setNegate(true);
    }



    /**
     * Initializes a filled-in NoneSet instance.
     * @param properties comma-delimited list of properties (non-null)
     * @param P condition's project
     **/
    public NoneSet(String properties, Project P)
    {
        super(AntX.rules+"noneset",properties,P);
        setNegate(true);
    }



    /**
     * Sets this condition's list of properties as part of 
     * a value URI.
     * @param fragment the value uri bits (non-null)
     * @since JWare/AntX 0.5
     */
    public void xsetFromURI(String fragment)
    {
        xsetFromURIFragment(fragment);
    }
}

/* end-of-NoneSet.java */
