/**
 * $Id: AllSet.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition;

import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.AntX;

/**
 * Shortcut condition that returns <i>true</i> if all of the nested items (properties,
 * variables, references, etc.) are set in the project's environment. Can be
 * setup to set a project property "<i>true</i>" on  <i>true</i> evaluation.
 * <p>
 * <b>Example Usage:</b><pre>
 *   &lt;assert msgid="msg.stuff.missing"&gt;
 *     &lt;<b>allset</b> whitespace="ignore"&gt;
 *       &lt;property  name="module.id/&gt;
 *       &lt;property  name="module.basedir/&gt;
 *       &lt;reference name="module.classpath/&gt;
 *     &lt;/allset&gt;
 *   &lt;/assert&gt;
 *
 *   &lt;fixturecheck msgid="msg.stuff.missing"&gt;
 *     &lt;<b>allset</b> malformed="reject"&gt;
 *       &lt;property name="module.id/&gt;
 *       &lt;properties prefix="mybuild." ignorecase="yes"/&gt;
 *     &lt;/allset&gt;
 *   &lt;/fixturecheck&gt;
 * </pre>
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   api,infra
 * @see      IsNotSet
 * @see      NoneSet
 **/

public class AllSet extends CheckSetCondition implements URIable
{
    /**
     * Initializes new AllSet condition; defaults to returning <i>false</i>.
     **/
    public AllSet()
    {
        super(AntX.rules+"allset");
    }


    /**
     * Initializes new CV-labeled AllSet condition; defaults to
     * returning <i>false</i>.
     * @param iam CV-label (non-null)
     **/
    public AllSet(String iam)
    {
        super(iam);
    }


    /**
     * Initializes a CV-labeled filled in AllSet instance.
     * @param properties comma-delimited list of properties
     * @param P condition's project
     **/
    protected AllSet(String iam, String properties, final Project P)
    {
        super(iam);
        setProject(P);
        setProperties(properties);
    }


    /**
     * Initializes a filled in AllSet instance.
     * @param properties comma-delimited list of properties
     * @param P condition's project
     **/
    public AllSet(String properties, final Project P)
    {
        this(AntX.rules+"allset",properties,P);
    }



    /**
     * Sets this condition's list of properties as part of 
     * a value URI.
     * @param fragment the value uri bits (non-null)
     * @since JWare/AntX 0.5
     */
    public void xsetFromURI(String fragment)
    {
        xsetFromURIFragment(fragment);
    }



    /**
     * Tells this set check to look for items with a positive
     * boolean string as a value.
     * @param allTrue <i>true</i> to force boolean check.
     * @since JWare/AntX 0.5
     **/
    public final void setAllTrue(boolean allTrue)
    {
        if (allTrue) {
            setTruesOnly();
        } 
    }
}

/* end-of-AllSet.java */
