/**
 * $Id: ValueURIHandler.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx;

import  com.idaremedia.antx.apis.Requester;

/**
 * Handler for a custom AntX value-URI (or set of value-URIs). You must explicitly
 * install most value URI handlers including those built into AntX; see
 * {@linkplain com.idaremedia.antx.solo.ValueURIManagerTask} for more information.
 *
 * @since     JWare/AntX 0.5
 * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version   0.5
 * @.safety   n/a
 * @.group    api,infra
 **/

public interface ValueURIHandler
{
    /**
     * Returns this value handler's default value when incoming script
     * identifier does not match any fixture data or identifier is
     * malformed.
     * @param fullUri [optional] the script-facing value uri
     * @param clnt caller location and problem handler (non-null)
     * @return default value for this type of value uri or <i>null</i>
     **/
    String getDefaultValue(String fullUri, Requester clnt);



    /**
     * Returns the current value represented by the given value uri.
     * @param uriFragment resource information from uri (non-null)
     * @param fullUri full script-facing value uri (non-null)
     * @param clnt caller location and problem handler (non-null)
     * @return stringified from of resource identified by value uri.
     **/
    String valueFrom(String uriFragment, String fullUri, Requester clnt);



    /**
     * Null proxy class used by value URI handler factories. Instances
     * of this class never resolve any supplied uri (always returns <i>null</i>).
     * @since     JWare/AntX 0.5
     * @author    ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
     * @version   0.5
     * @.safety   multiple
     * @.group    impl,helper
     **/
    public static final class None implements ValueURIHandler
    {
        /** Initialize a new no-op proxy instance. **/
        public None() {
        }
        /** Returns <i>null</i> always. **/
        public String getDefaultValue(String fullURI, Requester clnt) {
            return null;
        }
        /** Returns <i>null</i> always. **/
        public String valueFrom(String fragment, String full, Requester clnt) {
            return null;
        }
    }
}

/* end-of-ValueURIHandler.java */